package zio.aws.sso.model
import zio.ZIO
import zio.aws.core.BuilderHelper
import zio.aws.sso.model.primitives.{
  AccessTokenType,
  AccountIdType,
  RoleNameType
}
import scala.jdk.CollectionConverters._
final case class GetRoleCredentialsRequest(
    roleName: RoleNameType,
    accountId: AccountIdType,
    accessToken: AccessTokenType
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.sso.model.GetRoleCredentialsRequest = {
    import GetRoleCredentialsRequest.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.sso.model.GetRoleCredentialsRequest
      .builder()
      .roleName(RoleNameType.unwrap(roleName): java.lang.String)
      .accountId(AccountIdType.unwrap(accountId): java.lang.String)
      .accessToken(AccessTokenType.unwrap(accessToken): java.lang.String)
      .build()
  }
  def asReadOnly: zio.aws.sso.model.GetRoleCredentialsRequest.ReadOnly =
    zio.aws.sso.model.GetRoleCredentialsRequest.wrap(buildAwsValue())
}
object GetRoleCredentialsRequest {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.sso.model.GetRoleCredentialsRequest
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.sso.model.GetRoleCredentialsRequest =
      zio.aws.sso.model
        .GetRoleCredentialsRequest(roleName, accountId, accessToken)
    def roleName: RoleNameType
    def accountId: AccountIdType
    def accessToken: AccessTokenType
    def getRoleName: ZIO[Any, Nothing, RoleNameType] = ZIO.succeed(roleName)
    def getAccountId: ZIO[Any, Nothing, AccountIdType] = ZIO.succeed(accountId)
    def getAccessToken: ZIO[Any, Nothing, AccessTokenType] =
      ZIO.succeed(accessToken)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.sso.model.GetRoleCredentialsRequest
  ) extends zio.aws.sso.model.GetRoleCredentialsRequest.ReadOnly {
    override val roleName: RoleNameType =
      zio.aws.sso.model.primitives.RoleNameType(impl.roleName())
    override val accountId: AccountIdType =
      zio.aws.sso.model.primitives.AccountIdType(impl.accountId())
    override val accessToken: AccessTokenType =
      zio.aws.sso.model.primitives.AccessTokenType(impl.accessToken())
  }
  def wrap(
      impl: software.amazon.awssdk.services.sso.model.GetRoleCredentialsRequest
  ): zio.aws.sso.model.GetRoleCredentialsRequest.ReadOnly = new Wrapper(impl)
}
