package zio.aws.sso
import zio.prelude.Subtype
import zio.aws.sso.model.primitives.AccessKeyType.Type
package object model {
  import scala.jdk.CollectionConverters._
  object primitives {
    object AccessKeyType extends Subtype[String]
    type AccessKeyType = zio.aws.sso.model.primitives.AccessKeyType.Type
    object AccessTokenType extends Subtype[String]
    type AccessTokenType = zio.aws.sso.model.primitives.AccessTokenType.Type
    object AccountIdType extends Subtype[String]
    type AccountIdType = zio.aws.sso.model.primitives.AccountIdType.Type
    object AccountNameType extends Subtype[String]
    type AccountNameType = zio.aws.sso.model.primitives.AccountNameType.Type
    object EmailAddressType extends Subtype[String]
    type EmailAddressType = zio.aws.sso.model.primitives.EmailAddressType.Type
    object ExpirationTimestampType extends Subtype[Long]
    type ExpirationTimestampType =
      zio.aws.sso.model.primitives.ExpirationTimestampType.Type
    object MaxResultType extends Subtype[Int]
    type MaxResultType = zio.aws.sso.model.primitives.MaxResultType.Type
    object NextTokenType extends Subtype[String]
    type NextTokenType = zio.aws.sso.model.primitives.NextTokenType.Type
    object RoleNameType extends Subtype[String]
    type RoleNameType = zio.aws.sso.model.primitives.RoleNameType.Type
    object SecretAccessKeyType extends Subtype[String]
    type SecretAccessKeyType =
      zio.aws.sso.model.primitives.SecretAccessKeyType.Type
    object SessionTokenType extends Subtype[String]
    type SessionTokenType = zio.aws.sso.model.primitives.SessionTokenType.Type
  }
  type AccountListType = List[zio.aws.sso.model.AccountInfo]
  type RoleListType = List[zio.aws.sso.model.RoleInfo]
}
