package zio.aws.sso.model
import zio.ZIO
import zio.aws.core.{AwsError, BuilderHelper}
import zio.aws.sso.model.primitives.NextTokenType
import scala.jdk.CollectionConverters._
final case class ListAccountsResponse(
    nextToken: Option[NextTokenType] = None,
    accountList: Option[Iterable[zio.aws.sso.model.AccountInfo]] = None
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.sso.model.ListAccountsResponse = {
    import ListAccountsResponse.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.sso.model.ListAccountsResponse
      .builder()
      .optionallyWith(
        nextToken.map(value => NextTokenType.unwrap(value): java.lang.String)
      )(_.nextToken)
      .optionallyWith(
        accountList.map(value =>
          value.map { item =>
            item.buildAwsValue()
          }.asJavaCollection
        )
      )(_.accountList)
      .build()
  }
  def asReadOnly: zio.aws.sso.model.ListAccountsResponse.ReadOnly =
    zio.aws.sso.model.ListAccountsResponse.wrap(buildAwsValue())
}
object ListAccountsResponse {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.sso.model.ListAccountsResponse
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.sso.model.ListAccountsResponse =
      zio.aws.sso.model.ListAccountsResponse(
        nextToken.map(value => value),
        accountList.map(value =>
          value.map { item =>
            item.asEditable
          }
        )
      )
    def nextToken: Option[NextTokenType]
    def accountList: Option[List[zio.aws.sso.model.AccountInfo.ReadOnly]]
    def getNextToken: ZIO[Any, AwsError, NextTokenType] =
      AwsError.unwrapOptionField("nextToken", nextToken)
    def getAccountList
        : ZIO[Any, AwsError, List[zio.aws.sso.model.AccountInfo.ReadOnly]] =
      AwsError.unwrapOptionField("accountList", accountList)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.sso.model.ListAccountsResponse
  ) extends zio.aws.sso.model.ListAccountsResponse.ReadOnly {
    override val nextToken: Option[NextTokenType] = scala
      .Option(impl.nextToken())
      .map(value => zio.aws.sso.model.primitives.NextTokenType(value))
    override val accountList
        : Option[List[zio.aws.sso.model.AccountInfo.ReadOnly]] = scala
      .Option(impl.accountList())
      .map(value =>
        value.asScala.map { item =>
          zio.aws.sso.model.AccountInfo.wrap(item)
        }.toList
      )
  }
  def wrap(
      impl: software.amazon.awssdk.services.sso.model.ListAccountsResponse
  ): zio.aws.sso.model.ListAccountsResponse.ReadOnly = new Wrapper(impl)
}
