package zio.aws.sso.model
import zio.ZIO
import zio.aws.core.{AwsError, BuilderHelper}
import zio.aws.sso.model.primitives.NextTokenType
import scala.jdk.CollectionConverters._
final case class ListAccountRolesResponse(
    nextToken: Option[NextTokenType] = None,
    roleList: Option[Iterable[zio.aws.sso.model.RoleInfo]] = None
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.sso.model.ListAccountRolesResponse = {
    import ListAccountRolesResponse.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.sso.model.ListAccountRolesResponse
      .builder()
      .optionallyWith(
        nextToken.map(value => NextTokenType.unwrap(value): java.lang.String)
      )(_.nextToken)
      .optionallyWith(
        roleList.map(value =>
          value.map { item =>
            item.buildAwsValue()
          }.asJavaCollection
        )
      )(_.roleList)
      .build()
  }
  def asReadOnly: zio.aws.sso.model.ListAccountRolesResponse.ReadOnly =
    zio.aws.sso.model.ListAccountRolesResponse.wrap(buildAwsValue())
}
object ListAccountRolesResponse {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.sso.model.ListAccountRolesResponse
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.sso.model.ListAccountRolesResponse =
      zio.aws.sso.model.ListAccountRolesResponse(
        nextToken.map(value => value),
        roleList.map(value =>
          value.map { item =>
            item.asEditable
          }
        )
      )
    def nextToken: Option[NextTokenType]
    def roleList: Option[List[zio.aws.sso.model.RoleInfo.ReadOnly]]
    def getNextToken: ZIO[Any, AwsError, NextTokenType] =
      AwsError.unwrapOptionField("nextToken", nextToken)
    def getRoleList
        : ZIO[Any, AwsError, List[zio.aws.sso.model.RoleInfo.ReadOnly]] =
      AwsError.unwrapOptionField("roleList", roleList)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.sso.model.ListAccountRolesResponse
  ) extends zio.aws.sso.model.ListAccountRolesResponse.ReadOnly {
    override val nextToken: Option[NextTokenType] = scala
      .Option(impl.nextToken())
      .map(value => zio.aws.sso.model.primitives.NextTokenType(value))
    override val roleList: Option[List[zio.aws.sso.model.RoleInfo.ReadOnly]] =
      scala
        .Option(impl.roleList())
        .map(value =>
          value.asScala.map { item =>
            zio.aws.sso.model.RoleInfo.wrap(item)
          }.toList
        )
  }
  def wrap(
      impl: software.amazon.awssdk.services.sso.model.ListAccountRolesResponse
  ): zio.aws.sso.model.ListAccountRolesResponse.ReadOnly = new Wrapper(impl)
}
