package zio.aws.sso.model
import zio.ZIO
import zio.aws.core.{AwsError, BuilderHelper}
import zio.aws.sso.model.primitives.{
  ExpirationTimestampType,
  SessionTokenType,
  SecretAccessKeyType,
  AccessKeyType
}
import scala.jdk.CollectionConverters._
final case class RoleCredentials(
    accessKeyId: Option[AccessKeyType] = None,
    secretAccessKey: Option[SecretAccessKeyType] = None,
    sessionToken: Option[SessionTokenType] = None,
    expiration: Option[ExpirationTimestampType] = None
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.sso.model.RoleCredentials = {
    import RoleCredentials.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.sso.model.RoleCredentials
      .builder()
      .optionallyWith(
        accessKeyId.map(value => AccessKeyType.unwrap(value): java.lang.String)
      )(_.accessKeyId)
      .optionallyWith(
        secretAccessKey.map(value =>
          SecretAccessKeyType.unwrap(value): java.lang.String
        )
      )(_.secretAccessKey)
      .optionallyWith(
        sessionToken.map(value =>
          SessionTokenType.unwrap(value): java.lang.String
        )
      )(_.sessionToken)
      .optionallyWith(
        expiration.map(value =>
          ExpirationTimestampType.unwrap(value): java.lang.Long
        )
      )(_.expiration)
      .build()
  }
  def asReadOnly: zio.aws.sso.model.RoleCredentials.ReadOnly =
    zio.aws.sso.model.RoleCredentials.wrap(buildAwsValue())
}
object RoleCredentials {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.sso.model.RoleCredentials
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.sso.model.RoleCredentials =
      zio.aws.sso.model.RoleCredentials(
        accessKeyId.map(value => value),
        secretAccessKey.map(value => value),
        sessionToken.map(value => value),
        expiration.map(value => value)
      )
    def accessKeyId: Option[AccessKeyType]
    def secretAccessKey: Option[SecretAccessKeyType]
    def sessionToken: Option[SessionTokenType]
    def expiration: Option[ExpirationTimestampType]
    def getAccessKeyId: ZIO[Any, AwsError, AccessKeyType] =
      AwsError.unwrapOptionField("accessKeyId", accessKeyId)
    def getSecretAccessKey: ZIO[Any, AwsError, SecretAccessKeyType] =
      AwsError.unwrapOptionField("secretAccessKey", secretAccessKey)
    def getSessionToken: ZIO[Any, AwsError, SessionTokenType] =
      AwsError.unwrapOptionField("sessionToken", sessionToken)
    def getExpiration: ZIO[Any, AwsError, ExpirationTimestampType] =
      AwsError.unwrapOptionField("expiration", expiration)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.sso.model.RoleCredentials
  ) extends zio.aws.sso.model.RoleCredentials.ReadOnly {
    override val accessKeyId: Option[AccessKeyType] = scala
      .Option(impl.accessKeyId())
      .map(value => zio.aws.sso.model.primitives.AccessKeyType(value))
    override val secretAccessKey: Option[SecretAccessKeyType] = scala
      .Option(impl.secretAccessKey())
      .map(value => zio.aws.sso.model.primitives.SecretAccessKeyType(value))
    override val sessionToken: Option[SessionTokenType] = scala
      .Option(impl.sessionToken())
      .map(value => zio.aws.sso.model.primitives.SessionTokenType(value))
    override val expiration: Option[ExpirationTimestampType] = scala
      .Option(impl.expiration())
      .map(value => zio.aws.sso.model.primitives.ExpirationTimestampType(value))
  }
  def wrap(
      impl: software.amazon.awssdk.services.sso.model.RoleCredentials
  ): zio.aws.sso.model.RoleCredentials.ReadOnly = new Wrapper(impl)
}
