package zio.aws.sso.model
import java.lang.Integer
import zio.ZIO
import zio.aws.core.{AwsError, BuilderHelper}
import zio.aws.sso.model.primitives.{
  AccessTokenType,
  MaxResultType,
  NextTokenType
}
import scala.jdk.CollectionConverters._
final case class ListAccountsRequest(
    nextToken: Option[NextTokenType] = None,
    maxResults: Option[MaxResultType] = None,
    accessToken: AccessTokenType
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.sso.model.ListAccountsRequest = {
    import ListAccountsRequest.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.sso.model.ListAccountsRequest
      .builder()
      .optionallyWith(
        nextToken.map(value => NextTokenType.unwrap(value): java.lang.String)
      )(_.nextToken)
      .optionallyWith(
        maxResults.map(value => MaxResultType.unwrap(value): Integer)
      )(_.maxResults)
      .accessToken(AccessTokenType.unwrap(accessToken): java.lang.String)
      .build()
  }
  def asReadOnly: zio.aws.sso.model.ListAccountsRequest.ReadOnly =
    zio.aws.sso.model.ListAccountsRequest.wrap(buildAwsValue())
}
object ListAccountsRequest {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.sso.model.ListAccountsRequest
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.sso.model.ListAccountsRequest =
      zio.aws.sso.model.ListAccountsRequest(
        nextToken.map(value => value),
        maxResults.map(value => value),
        accessToken
      )
    def nextToken: Option[NextTokenType]
    def maxResults: Option[MaxResultType]
    def accessToken: AccessTokenType
    def getNextToken: ZIO[Any, AwsError, NextTokenType] =
      AwsError.unwrapOptionField("nextToken", nextToken)
    def getMaxResults: ZIO[Any, AwsError, MaxResultType] =
      AwsError.unwrapOptionField("maxResults", maxResults)
    def getAccessToken: ZIO[Any, Nothing, AccessTokenType] =
      ZIO.succeed(accessToken)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.sso.model.ListAccountsRequest
  ) extends zio.aws.sso.model.ListAccountsRequest.ReadOnly {
    override val nextToken: Option[NextTokenType] = scala
      .Option(impl.nextToken())
      .map(value => zio.aws.sso.model.primitives.NextTokenType(value))
    override val maxResults: Option[MaxResultType] = scala
      .Option(impl.maxResults())
      .map(value => zio.aws.sso.model.primitives.MaxResultType(value))
    override val accessToken: AccessTokenType =
      zio.aws.sso.model.primitives.AccessTokenType(impl.accessToken())
  }
  def wrap(
      impl: software.amazon.awssdk.services.sso.model.ListAccountsRequest
  ): zio.aws.sso.model.ListAccountsRequest.ReadOnly = new Wrapper(impl)
}
