package zio.aws.sso.model
import zio.ZIO
import zio.aws.core.{AwsError, BuilderHelper}
import scala.jdk.CollectionConverters._
final case class GetRoleCredentialsResponse(
    roleCredentials: Option[zio.aws.sso.model.RoleCredentials] = None
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.sso.model.GetRoleCredentialsResponse = {
    import GetRoleCredentialsResponse.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.sso.model.GetRoleCredentialsResponse
      .builder()
      .optionallyWith(roleCredentials.map(value => value.buildAwsValue()))(
        _.roleCredentials
      )
      .build()
  }
  def asReadOnly: zio.aws.sso.model.GetRoleCredentialsResponse.ReadOnly =
    zio.aws.sso.model.GetRoleCredentialsResponse.wrap(buildAwsValue())
}
object GetRoleCredentialsResponse {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.sso.model.GetRoleCredentialsResponse
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.sso.model.GetRoleCredentialsResponse =
      zio.aws.sso.model.GetRoleCredentialsResponse(
        roleCredentials.map(value => value.asEditable)
      )
    def roleCredentials: Option[zio.aws.sso.model.RoleCredentials.ReadOnly]
    def getRoleCredentials
        : ZIO[Any, AwsError, zio.aws.sso.model.RoleCredentials.ReadOnly] =
      AwsError.unwrapOptionField("roleCredentials", roleCredentials)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.sso.model.GetRoleCredentialsResponse
  ) extends zio.aws.sso.model.GetRoleCredentialsResponse.ReadOnly {
    override val roleCredentials
        : Option[zio.aws.sso.model.RoleCredentials.ReadOnly] = scala
      .Option(impl.roleCredentials())
      .map(value => zio.aws.sso.model.RoleCredentials.wrap(value))
  }
  def wrap(
      impl: software.amazon.awssdk.services.sso.model.GetRoleCredentialsResponse
  ): zio.aws.sso.model.GetRoleCredentialsResponse.ReadOnly = new Wrapper(impl)
}
