package zio.aws.ssmsap.model
import zio.ZIO
import zio.aws.core.{AwsError, BuilderHelper}
import zio.prelude.data.Optional
import scala.jdk.CollectionConverters.*
final case class IpAddressMember(
    ipAddress: Optional[String] = Optional.Absent,
    primary: Optional[Boolean] = Optional.Absent,
    allocationType: Optional[zio.aws.ssmsap.model.AllocationType] =
      Optional.Absent
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.ssmsap.model.IpAddressMember = {
    import IpAddressMember.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.ssmsap.model.IpAddressMember
      .builder()
      .optionallyWith(ipAddress.map(value => value: java.lang.String))(
        _.ipAddress
      )
      .optionallyWith(primary.map(value => value: java.lang.Boolean))(_.primary)
      .optionallyWith(allocationType.map(value => value.unwrap))(
        _.allocationType
      )
      .build()
  }
  def asReadOnly: zio.aws.ssmsap.model.IpAddressMember.ReadOnly =
    zio.aws.ssmsap.model.IpAddressMember.wrap(buildAwsValue())
}
object IpAddressMember {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.ssmsap.model.IpAddressMember
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.ssmsap.model.IpAddressMember =
      zio.aws.ssmsap.model.IpAddressMember(
        ipAddress.map(value => value),
        primary.map(value => value),
        allocationType.map(value => value)
      )
    def ipAddress: Optional[String]
    def primary: Optional[Boolean]
    def allocationType: Optional[zio.aws.ssmsap.model.AllocationType]
    def getIpAddress: ZIO[Any, AwsError, String] =
      AwsError.unwrapOptionField("ipAddress", ipAddress)
    def getPrimary: ZIO[Any, AwsError, Boolean] =
      AwsError.unwrapOptionField("primary", primary)
    def getAllocationType
        : ZIO[Any, AwsError, zio.aws.ssmsap.model.AllocationType] =
      AwsError.unwrapOptionField("allocationType", allocationType)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.ssmsap.model.IpAddressMember
  ) extends zio.aws.ssmsap.model.IpAddressMember.ReadOnly {
    override val ipAddress: Optional[String] = zio.aws.core.internal
      .optionalFromNullable(impl.ipAddress())
      .map(value => value: String)
    override val primary: Optional[Boolean] = zio.aws.core.internal
      .optionalFromNullable(impl.primary())
      .map(value => value: Boolean)
    override val allocationType: Optional[zio.aws.ssmsap.model.AllocationType] =
      zio.aws.core.internal
        .optionalFromNullable(impl.allocationType())
        .map(value => zio.aws.ssmsap.model.AllocationType.wrap(value))
  }
  def wrap(
      impl: software.amazon.awssdk.services.ssmsap.model.IpAddressMember
  ): zio.aws.ssmsap.model.IpAddressMember.ReadOnly = new Wrapper(impl)
}
