package zio.aws.ssmsap.model
import zio.aws.ssmsap.model.primitives.SsmSapArn
import zio.ZIO
import zio.aws.core.{AwsError, BuilderHelper}
import zio.prelude.data.Optional
import scala.jdk.CollectionConverters.*
final case class DatabaseConnection(
    databaseConnectionMethod: Optional[
      zio.aws.ssmsap.model.DatabaseConnectionMethod
    ] = Optional.Absent,
    databaseArn: Optional[SsmSapArn] = Optional.Absent,
    connectionIp: Optional[String] = Optional.Absent
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.ssmsap.model.DatabaseConnection = {
    import DatabaseConnection.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.ssmsap.model.DatabaseConnection
      .builder()
      .optionallyWith(databaseConnectionMethod.map(value => value.unwrap))(
        _.databaseConnectionMethod
      )
      .optionallyWith(
        databaseArn.map(value => SsmSapArn.unwrap(value): java.lang.String)
      )(_.databaseArn)
      .optionallyWith(connectionIp.map(value => value: java.lang.String))(
        _.connectionIp
      )
      .build()
  }
  def asReadOnly: zio.aws.ssmsap.model.DatabaseConnection.ReadOnly =
    zio.aws.ssmsap.model.DatabaseConnection.wrap(buildAwsValue())
}
object DatabaseConnection {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.ssmsap.model.DatabaseConnection
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.ssmsap.model.DatabaseConnection =
      zio.aws.ssmsap.model.DatabaseConnection(
        databaseConnectionMethod.map(value => value),
        databaseArn.map(value => value),
        connectionIp.map(value => value)
      )
    def databaseConnectionMethod
        : Optional[zio.aws.ssmsap.model.DatabaseConnectionMethod]
    def databaseArn: Optional[SsmSapArn]
    def connectionIp: Optional[String]
    def getDatabaseConnectionMethod
        : ZIO[Any, AwsError, zio.aws.ssmsap.model.DatabaseConnectionMethod] =
      AwsError.unwrapOptionField(
        "databaseConnectionMethod",
        databaseConnectionMethod
      )
    def getDatabaseArn: ZIO[Any, AwsError, SsmSapArn] =
      AwsError.unwrapOptionField("databaseArn", databaseArn)
    def getConnectionIp: ZIO[Any, AwsError, String] =
      AwsError.unwrapOptionField("connectionIp", connectionIp)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.ssmsap.model.DatabaseConnection
  ) extends zio.aws.ssmsap.model.DatabaseConnection.ReadOnly {
    override val databaseConnectionMethod
        : Optional[zio.aws.ssmsap.model.DatabaseConnectionMethod] =
      zio.aws.core.internal
        .optionalFromNullable(impl.databaseConnectionMethod())
        .map(value => zio.aws.ssmsap.model.DatabaseConnectionMethod.wrap(value))
    override val databaseArn: Optional[SsmSapArn] = zio.aws.core.internal
      .optionalFromNullable(impl.databaseArn())
      .map(value => zio.aws.ssmsap.model.primitives.SsmSapArn(value))
    override val connectionIp: Optional[String] = zio.aws.core.internal
      .optionalFromNullable(impl.connectionIp())
      .map(value => value: String)
  }
  def wrap(
      impl: software.amazon.awssdk.services.ssmsap.model.DatabaseConnection
  ): zio.aws.ssmsap.model.DatabaseConnection.ReadOnly = new Wrapper(impl)
}
