package zio.aws.ssmsap.model
import zio.ZIO
import zio.aws.core.BuilderHelper
import scala.jdk.CollectionConverters.*
final case class BackintConfig(
    backintMode: zio.aws.ssmsap.model.BackintMode,
    ensureNoBackupInProcess: Boolean
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.ssmsap.model.BackintConfig = {
    import BackintConfig.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.ssmsap.model.BackintConfig
      .builder()
      .backintMode(backintMode.unwrap)
      .ensureNoBackupInProcess(ensureNoBackupInProcess: java.lang.Boolean)
      .build()
  }
  def asReadOnly: zio.aws.ssmsap.model.BackintConfig.ReadOnly =
    zio.aws.ssmsap.model.BackintConfig.wrap(buildAwsValue())
}
object BackintConfig {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.ssmsap.model.BackintConfig
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.ssmsap.model.BackintConfig =
      zio.aws.ssmsap.model.BackintConfig(backintMode, ensureNoBackupInProcess)
    def backintMode: zio.aws.ssmsap.model.BackintMode
    def ensureNoBackupInProcess: Boolean
    def getBackintMode: ZIO[Any, Nothing, zio.aws.ssmsap.model.BackintMode] =
      ZIO.succeed(backintMode)
    def getEnsureNoBackupInProcess: ZIO[Any, Nothing, Boolean] =
      ZIO.succeed(ensureNoBackupInProcess)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.ssmsap.model.BackintConfig
  ) extends zio.aws.ssmsap.model.BackintConfig.ReadOnly {
    override val backintMode: zio.aws.ssmsap.model.BackintMode =
      zio.aws.ssmsap.model.BackintMode.wrap(impl.backintMode())
    override val ensureNoBackupInProcess: Boolean =
      impl.ensureNoBackupInProcess(): Boolean
  }
  def wrap(
      impl: software.amazon.awssdk.services.ssmsap.model.BackintConfig
  ): zio.aws.ssmsap.model.BackintConfig.ReadOnly = new Wrapper(impl)
}
