package zio.aws.ssmsap.model
import scala.jdk.CollectionConverters.*
sealed trait ApplicationDiscoveryStatus {
  def unwrap
      : software.amazon.awssdk.services.ssmsap.model.ApplicationDiscoveryStatus
}
object ApplicationDiscoveryStatus {
  def wrap(
      value: software.amazon.awssdk.services.ssmsap.model.ApplicationDiscoveryStatus
  ): zio.aws.ssmsap.model.ApplicationDiscoveryStatus = value match {
    case software.amazon.awssdk.services.ssmsap.model.ApplicationDiscoveryStatus.UNKNOWN_TO_SDK_VERSION =>
      val r = unknownToSdkVersion
      r
    case software.amazon.awssdk.services.ssmsap.model.ApplicationDiscoveryStatus.SUCCESS =>
      val r = SUCCESS
      r
    case software.amazon.awssdk.services.ssmsap.model.ApplicationDiscoveryStatus.REGISTRATION_FAILED =>
      val r = REGISTRATION_FAILED
      r
    case software.amazon.awssdk.services.ssmsap.model.ApplicationDiscoveryStatus.REFRESH_FAILED =>
      val r = REFRESH_FAILED
      r
    case software.amazon.awssdk.services.ssmsap.model.ApplicationDiscoveryStatus.REGISTERING =>
      val r = REGISTERING
      r
    case software.amazon.awssdk.services.ssmsap.model.ApplicationDiscoveryStatus.DELETING =>
      val r = DELETING
      r
  }
  case object unknownToSdkVersion
      extends zio.aws.ssmsap.model.ApplicationDiscoveryStatus {
    override def unwrap
        : software.amazon.awssdk.services.ssmsap.model.ApplicationDiscoveryStatus =
      software.amazon.awssdk.services.ssmsap.model.ApplicationDiscoveryStatus.UNKNOWN_TO_SDK_VERSION
  }
  case object SUCCESS extends zio.aws.ssmsap.model.ApplicationDiscoveryStatus {
    override def unwrap
        : software.amazon.awssdk.services.ssmsap.model.ApplicationDiscoveryStatus =
      software.amazon.awssdk.services.ssmsap.model.ApplicationDiscoveryStatus.SUCCESS
  }
  case object REGISTRATION_FAILED
      extends zio.aws.ssmsap.model.ApplicationDiscoveryStatus {
    override def unwrap
        : software.amazon.awssdk.services.ssmsap.model.ApplicationDiscoveryStatus =
      software.amazon.awssdk.services.ssmsap.model.ApplicationDiscoveryStatus.REGISTRATION_FAILED
  }
  case object REFRESH_FAILED
      extends zio.aws.ssmsap.model.ApplicationDiscoveryStatus {
    override def unwrap
        : software.amazon.awssdk.services.ssmsap.model.ApplicationDiscoveryStatus =
      software.amazon.awssdk.services.ssmsap.model.ApplicationDiscoveryStatus.REFRESH_FAILED
  }
  case object REGISTERING
      extends zio.aws.ssmsap.model.ApplicationDiscoveryStatus {
    override def unwrap
        : software.amazon.awssdk.services.ssmsap.model.ApplicationDiscoveryStatus =
      software.amazon.awssdk.services.ssmsap.model.ApplicationDiscoveryStatus.REGISTERING
  }
  case object DELETING extends zio.aws.ssmsap.model.ApplicationDiscoveryStatus {
    override def unwrap
        : software.amazon.awssdk.services.ssmsap.model.ApplicationDiscoveryStatus =
      software.amazon.awssdk.services.ssmsap.model.ApplicationDiscoveryStatus.DELETING
  }
}
