package zio.aws.ssmsap.model
import zio.aws.ssmsap.model.primitives.ApplicationId
import zio.ZIO
import zio.aws.core.BuilderHelper
import scala.jdk.CollectionConverters.*
final case class StartApplicationRefreshRequest(applicationId: ApplicationId) {
  def buildAwsValue()
      : software.amazon.awssdk.services.ssmsap.model.StartApplicationRefreshRequest = {
    import StartApplicationRefreshRequest.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.ssmsap.model.StartApplicationRefreshRequest
      .builder()
      .applicationId(ApplicationId.unwrap(applicationId): java.lang.String)
      .build()
  }
  def asReadOnly: zio.aws.ssmsap.model.StartApplicationRefreshRequest.ReadOnly =
    zio.aws.ssmsap.model.StartApplicationRefreshRequest.wrap(buildAwsValue())
}
object StartApplicationRefreshRequest {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.ssmsap.model.StartApplicationRefreshRequest
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.ssmsap.model.StartApplicationRefreshRequest =
      zio.aws.ssmsap.model.StartApplicationRefreshRequest(applicationId)
    def applicationId: ApplicationId
    def getApplicationId: ZIO[Any, Nothing, ApplicationId] =
      ZIO.succeed(applicationId)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.ssmsap.model.StartApplicationRefreshRequest
  ) extends zio.aws.ssmsap.model.StartApplicationRefreshRequest.ReadOnly {
    override val applicationId: ApplicationId =
      zio.aws.ssmsap.model.primitives.ApplicationId(impl.applicationId())
  }
  def wrap(
      impl: software.amazon.awssdk.services.ssmsap.model.StartApplicationRefreshRequest
  ): zio.aws.ssmsap.model.StartApplicationRefreshRequest.ReadOnly = new Wrapper(
    impl
  )
}
