package zio.aws.ssmsap.model
import zio.aws.ssmsap.model.primitives.NextToken
import zio.ZIO
import zio.aws.core.{AwsError, BuilderHelper}
import zio.prelude.data.Optional
import scala.jdk.CollectionConverters.*
final case class ListComponentsResponse(
    components: Optional[Iterable[zio.aws.ssmsap.model.ComponentSummary]] =
      Optional.Absent,
    nextToken: Optional[NextToken] = Optional.Absent
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.ssmsap.model.ListComponentsResponse = {
    import ListComponentsResponse.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.ssmsap.model.ListComponentsResponse
      .builder()
      .optionallyWith(
        components.map(value =>
          value.map { item =>
            item.buildAwsValue()
          }.asJavaCollection
        )
      )(_.components)
      .optionallyWith(
        nextToken.map(value => NextToken.unwrap(value): java.lang.String)
      )(_.nextToken)
      .build()
  }
  def asReadOnly: zio.aws.ssmsap.model.ListComponentsResponse.ReadOnly =
    zio.aws.ssmsap.model.ListComponentsResponse.wrap(buildAwsValue())
}
object ListComponentsResponse {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.ssmsap.model.ListComponentsResponse
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.ssmsap.model.ListComponentsResponse =
      zio.aws.ssmsap.model.ListComponentsResponse(
        components.map(value =>
          value.map { item =>
            item.asEditable
          }
        ),
        nextToken.map(value => value)
      )
    def components
        : Optional[List[zio.aws.ssmsap.model.ComponentSummary.ReadOnly]]
    def nextToken: Optional[NextToken]
    def getComponents: ZIO[Any, AwsError, List[
      zio.aws.ssmsap.model.ComponentSummary.ReadOnly
    ]] = AwsError.unwrapOptionField("components", components)
    def getNextToken: ZIO[Any, AwsError, NextToken] =
      AwsError.unwrapOptionField("nextToken", nextToken)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.ssmsap.model.ListComponentsResponse
  ) extends zio.aws.ssmsap.model.ListComponentsResponse.ReadOnly {
    override val components
        : Optional[List[zio.aws.ssmsap.model.ComponentSummary.ReadOnly]] =
      zio.aws.core.internal
        .optionalFromNullable(impl.components())
        .map(value =>
          value.asScala.map { item =>
            zio.aws.ssmsap.model.ComponentSummary.wrap(item)
          }.toList
        )
    override val nextToken: Optional[NextToken] = zio.aws.core.internal
      .optionalFromNullable(impl.nextToken())
      .map(value => zio.aws.ssmsap.model.primitives.NextToken(value))
  }
  def wrap(
      impl: software.amazon.awssdk.services.ssmsap.model.ListComponentsResponse
  ): zio.aws.ssmsap.model.ListComponentsResponse.ReadOnly = new Wrapper(impl)
}
