package zio.aws.ssmsap.model
import zio.ZIO
import zio.aws.core.{AwsError, BuilderHelper}
import zio.prelude.data.Optional
import scala.jdk.CollectionConverters.*
final case class Resilience(
    hsrTier: Optional[String] = Optional.Absent,
    hsrReplicationMode: Optional[zio.aws.ssmsap.model.ReplicationMode] =
      Optional.Absent,
    hsrOperationMode: Optional[zio.aws.ssmsap.model.OperationMode] =
      Optional.Absent,
    clusterStatus: Optional[zio.aws.ssmsap.model.ClusterStatus] =
      Optional.Absent,
    enqueueReplication: Optional[Boolean] = Optional.Absent
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.ssmsap.model.Resilience = {
    import Resilience.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.ssmsap.model.Resilience
      .builder()
      .optionallyWith(hsrTier.map(value => value: java.lang.String))(_.hsrTier)
      .optionallyWith(hsrReplicationMode.map(value => value.unwrap))(
        _.hsrReplicationMode
      )
      .optionallyWith(hsrOperationMode.map(value => value.unwrap))(
        _.hsrOperationMode
      )
      .optionallyWith(clusterStatus.map(value => value.unwrap))(_.clusterStatus)
      .optionallyWith(
        enqueueReplication.map(value => value: java.lang.Boolean)
      )(_.enqueueReplication)
      .build()
  }
  def asReadOnly: zio.aws.ssmsap.model.Resilience.ReadOnly =
    zio.aws.ssmsap.model.Resilience.wrap(buildAwsValue())
}
object Resilience {
  private lazy val zioAwsBuilderHelper
      : BuilderHelper[software.amazon.awssdk.services.ssmsap.model.Resilience] =
    BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.ssmsap.model.Resilience =
      zio.aws.ssmsap.model.Resilience(
        hsrTier.map(value => value),
        hsrReplicationMode.map(value => value),
        hsrOperationMode.map(value => value),
        clusterStatus.map(value => value),
        enqueueReplication.map(value => value)
      )
    def hsrTier: Optional[String]
    def hsrReplicationMode: Optional[zio.aws.ssmsap.model.ReplicationMode]
    def hsrOperationMode: Optional[zio.aws.ssmsap.model.OperationMode]
    def clusterStatus: Optional[zio.aws.ssmsap.model.ClusterStatus]
    def enqueueReplication: Optional[Boolean]
    def getHsrTier: ZIO[Any, AwsError, String] =
      AwsError.unwrapOptionField("hsrTier", hsrTier)
    def getHsrReplicationMode
        : ZIO[Any, AwsError, zio.aws.ssmsap.model.ReplicationMode] =
      AwsError.unwrapOptionField("hsrReplicationMode", hsrReplicationMode)
    def getHsrOperationMode
        : ZIO[Any, AwsError, zio.aws.ssmsap.model.OperationMode] =
      AwsError.unwrapOptionField("hsrOperationMode", hsrOperationMode)
    def getClusterStatus
        : ZIO[Any, AwsError, zio.aws.ssmsap.model.ClusterStatus] =
      AwsError.unwrapOptionField("clusterStatus", clusterStatus)
    def getEnqueueReplication: ZIO[Any, AwsError, Boolean] =
      AwsError.unwrapOptionField("enqueueReplication", enqueueReplication)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.ssmsap.model.Resilience
  ) extends zio.aws.ssmsap.model.Resilience.ReadOnly {
    override val hsrTier: Optional[String] = zio.aws.core.internal
      .optionalFromNullable(impl.hsrTier())
      .map(value => value: String)
    override val hsrReplicationMode
        : Optional[zio.aws.ssmsap.model.ReplicationMode] = zio.aws.core.internal
      .optionalFromNullable(impl.hsrReplicationMode())
      .map(value => zio.aws.ssmsap.model.ReplicationMode.wrap(value))
    override val hsrOperationMode
        : Optional[zio.aws.ssmsap.model.OperationMode] = zio.aws.core.internal
      .optionalFromNullable(impl.hsrOperationMode())
      .map(value => zio.aws.ssmsap.model.OperationMode.wrap(value))
    override val clusterStatus: Optional[zio.aws.ssmsap.model.ClusterStatus] =
      zio.aws.core.internal
        .optionalFromNullable(impl.clusterStatus())
        .map(value => zio.aws.ssmsap.model.ClusterStatus.wrap(value))
    override val enqueueReplication: Optional[Boolean] = zio.aws.core.internal
      .optionalFromNullable(impl.enqueueReplication())
      .map(value => value: Boolean)
  }
  def wrap(
      impl: software.amazon.awssdk.services.ssmsap.model.Resilience
  ): zio.aws.ssmsap.model.Resilience.ReadOnly = new Wrapper(impl)
}
