package zio.aws.ssmsap.model
import scala.jdk.CollectionConverters.*
sealed trait DatabaseConnectionMethod {
  def unwrap
      : software.amazon.awssdk.services.ssmsap.model.DatabaseConnectionMethod
}
object DatabaseConnectionMethod {
  def wrap(
      value: software.amazon.awssdk.services.ssmsap.model.DatabaseConnectionMethod
  ): zio.aws.ssmsap.model.DatabaseConnectionMethod = value match {
    case software.amazon.awssdk.services.ssmsap.model.DatabaseConnectionMethod.UNKNOWN_TO_SDK_VERSION =>
      val r = unknownToSdkVersion
      r
    case software.amazon.awssdk.services.ssmsap.model.DatabaseConnectionMethod.DIRECT =>
      val r = DIRECT
      r
    case software.amazon.awssdk.services.ssmsap.model.DatabaseConnectionMethod.OVERLAY =>
      val r = OVERLAY
      r
  }
  case object unknownToSdkVersion
      extends zio.aws.ssmsap.model.DatabaseConnectionMethod {
    override def unwrap
        : software.amazon.awssdk.services.ssmsap.model.DatabaseConnectionMethod =
      software.amazon.awssdk.services.ssmsap.model.DatabaseConnectionMethod.UNKNOWN_TO_SDK_VERSION
  }
  case object DIRECT extends zio.aws.ssmsap.model.DatabaseConnectionMethod {
    override def unwrap
        : software.amazon.awssdk.services.ssmsap.model.DatabaseConnectionMethod =
      software.amazon.awssdk.services.ssmsap.model.DatabaseConnectionMethod.DIRECT
  }
  case object OVERLAY extends zio.aws.ssmsap.model.DatabaseConnectionMethod {
    override def unwrap
        : software.amazon.awssdk.services.ssmsap.model.DatabaseConnectionMethod =
      software.amazon.awssdk.services.ssmsap.model.DatabaseConnectionMethod.OVERLAY
  }
}
