package zio.aws.ssmsap.model
import zio.aws.ssmsap.model.primitives.Arn
import zio.ZIO
import zio.aws.core.BuilderHelper
import scala.jdk.CollectionConverters.*
final case class PutResourcePermissionRequest(
    actionType: zio.aws.ssmsap.model.PermissionActionType,
    sourceResourceArn: Arn,
    resourceArn: Arn
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.ssmsap.model.PutResourcePermissionRequest = {
    import PutResourcePermissionRequest.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.ssmsap.model.PutResourcePermissionRequest
      .builder()
      .actionType(actionType.unwrap)
      .sourceResourceArn(Arn.unwrap(sourceResourceArn): java.lang.String)
      .resourceArn(Arn.unwrap(resourceArn): java.lang.String)
      .build()
  }
  def asReadOnly: zio.aws.ssmsap.model.PutResourcePermissionRequest.ReadOnly =
    zio.aws.ssmsap.model.PutResourcePermissionRequest.wrap(buildAwsValue())
}
object PutResourcePermissionRequest {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.ssmsap.model.PutResourcePermissionRequest
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.ssmsap.model.PutResourcePermissionRequest =
      zio.aws.ssmsap.model.PutResourcePermissionRequest(
        actionType,
        sourceResourceArn,
        resourceArn
      )
    def actionType: zio.aws.ssmsap.model.PermissionActionType
    def sourceResourceArn: Arn
    def resourceArn: Arn
    def getActionType
        : ZIO[Any, Nothing, zio.aws.ssmsap.model.PermissionActionType] =
      ZIO.succeed(actionType)
    def getSourceResourceArn: ZIO[Any, Nothing, Arn] =
      ZIO.succeed(sourceResourceArn)
    def getResourceArn: ZIO[Any, Nothing, Arn] = ZIO.succeed(resourceArn)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.ssmsap.model.PutResourcePermissionRequest
  ) extends zio.aws.ssmsap.model.PutResourcePermissionRequest.ReadOnly {
    override val actionType: zio.aws.ssmsap.model.PermissionActionType =
      zio.aws.ssmsap.model.PermissionActionType.wrap(impl.actionType())
    override val sourceResourceArn: Arn =
      zio.aws.ssmsap.model.primitives.Arn(impl.sourceResourceArn())
    override val resourceArn: Arn =
      zio.aws.ssmsap.model.primitives.Arn(impl.resourceArn())
  }
  def wrap(
      impl: software.amazon.awssdk.services.ssmsap.model.PutResourcePermissionRequest
  ): zio.aws.ssmsap.model.PutResourcePermissionRequest.ReadOnly = new Wrapper(
    impl
  )
}
