package zio.aws.ssmsap.model
import scala.jdk.CollectionConverters.*
sealed trait OperationMode {
  def unwrap: software.amazon.awssdk.services.ssmsap.model.OperationMode
}
object OperationMode {
  def wrap(
      value: software.amazon.awssdk.services.ssmsap.model.OperationMode
  ): zio.aws.ssmsap.model.OperationMode = value match {
    case software.amazon.awssdk.services.ssmsap.model.OperationMode.UNKNOWN_TO_SDK_VERSION =>
      val r = unknownToSdkVersion
      r
    case software.amazon.awssdk.services.ssmsap.model.OperationMode.PRIMARY =>
      val r = PRIMARY
      r
    case software.amazon.awssdk.services.ssmsap.model.OperationMode.LOGREPLAY =>
      val r = LOGREPLAY
      r
    case software.amazon.awssdk.services.ssmsap.model.OperationMode.DELTA_DATASHIPPING =>
      val r = DELTA_DATASHIPPING
      r
    case software.amazon.awssdk.services.ssmsap.model.OperationMode.LOGREPLAY_READACCESS =>
      val r = LOGREPLAY_READACCESS
      r
    case software.amazon.awssdk.services.ssmsap.model.OperationMode.NONE =>
      val r = NONE
      r
  }
  case object unknownToSdkVersion extends zio.aws.ssmsap.model.OperationMode {
    override def unwrap
        : software.amazon.awssdk.services.ssmsap.model.OperationMode =
      software.amazon.awssdk.services.ssmsap.model.OperationMode.UNKNOWN_TO_SDK_VERSION
  }
  case object PRIMARY extends zio.aws.ssmsap.model.OperationMode {
    override def unwrap
        : software.amazon.awssdk.services.ssmsap.model.OperationMode =
      software.amazon.awssdk.services.ssmsap.model.OperationMode.PRIMARY
  }
  case object LOGREPLAY extends zio.aws.ssmsap.model.OperationMode {
    override def unwrap
        : software.amazon.awssdk.services.ssmsap.model.OperationMode =
      software.amazon.awssdk.services.ssmsap.model.OperationMode.LOGREPLAY
  }
  case object DELTA_DATASHIPPING extends zio.aws.ssmsap.model.OperationMode {
    override def unwrap
        : software.amazon.awssdk.services.ssmsap.model.OperationMode =
      software.amazon.awssdk.services.ssmsap.model.OperationMode.DELTA_DATASHIPPING
  }
  case object LOGREPLAY_READACCESS extends zio.aws.ssmsap.model.OperationMode {
    override def unwrap
        : software.amazon.awssdk.services.ssmsap.model.OperationMode =
      software.amazon.awssdk.services.ssmsap.model.OperationMode.LOGREPLAY_READACCESS
  }
  case object NONE extends zio.aws.ssmsap.model.OperationMode {
    override def unwrap
        : software.amazon.awssdk.services.ssmsap.model.OperationMode =
      software.amazon.awssdk.services.ssmsap.model.OperationMode.NONE
  }
}
