package zio.aws.ssmsap.model
import scala.jdk.CollectionConverters.*
sealed trait ComponentType {
  def unwrap: software.amazon.awssdk.services.ssmsap.model.ComponentType
}
object ComponentType {
  def wrap(
      value: software.amazon.awssdk.services.ssmsap.model.ComponentType
  ): zio.aws.ssmsap.model.ComponentType = value match {
    case software.amazon.awssdk.services.ssmsap.model.ComponentType.UNKNOWN_TO_SDK_VERSION =>
      val r = unknownToSdkVersion
      r
    case software.amazon.awssdk.services.ssmsap.model.ComponentType.HANA =>
      val r = HANA
      r
    case software.amazon.awssdk.services.ssmsap.model.ComponentType.HANA_NODE =>
      val r = HANA_NODE
      r
    case software.amazon.awssdk.services.ssmsap.model.ComponentType.ABAP =>
      val r = ABAP
      r
    case software.amazon.awssdk.services.ssmsap.model.ComponentType.ASCS =>
      val r = ASCS
      r
    case software.amazon.awssdk.services.ssmsap.model.ComponentType.DIALOG =>
      val r = DIALOG
      r
    case software.amazon.awssdk.services.ssmsap.model.ComponentType.WEBDISP =>
      val r = WEBDISP
      r
    case software.amazon.awssdk.services.ssmsap.model.ComponentType.WD =>
      val r = WD
      r
    case software.amazon.awssdk.services.ssmsap.model.ComponentType.ERS =>
      val r = ERS
      r
  }
  case object unknownToSdkVersion extends zio.aws.ssmsap.model.ComponentType {
    override def unwrap
        : software.amazon.awssdk.services.ssmsap.model.ComponentType =
      software.amazon.awssdk.services.ssmsap.model.ComponentType.UNKNOWN_TO_SDK_VERSION
  }
  case object HANA extends zio.aws.ssmsap.model.ComponentType {
    override def unwrap
        : software.amazon.awssdk.services.ssmsap.model.ComponentType =
      software.amazon.awssdk.services.ssmsap.model.ComponentType.HANA
  }
  case object HANA_NODE extends zio.aws.ssmsap.model.ComponentType {
    override def unwrap
        : software.amazon.awssdk.services.ssmsap.model.ComponentType =
      software.amazon.awssdk.services.ssmsap.model.ComponentType.HANA_NODE
  }
  case object ABAP extends zio.aws.ssmsap.model.ComponentType {
    override def unwrap
        : software.amazon.awssdk.services.ssmsap.model.ComponentType =
      software.amazon.awssdk.services.ssmsap.model.ComponentType.ABAP
  }
  case object ASCS extends zio.aws.ssmsap.model.ComponentType {
    override def unwrap
        : software.amazon.awssdk.services.ssmsap.model.ComponentType =
      software.amazon.awssdk.services.ssmsap.model.ComponentType.ASCS
  }
  case object DIALOG extends zio.aws.ssmsap.model.ComponentType {
    override def unwrap
        : software.amazon.awssdk.services.ssmsap.model.ComponentType =
      software.amazon.awssdk.services.ssmsap.model.ComponentType.DIALOG
  }
  case object WEBDISP extends zio.aws.ssmsap.model.ComponentType {
    override def unwrap
        : software.amazon.awssdk.services.ssmsap.model.ComponentType =
      software.amazon.awssdk.services.ssmsap.model.ComponentType.WEBDISP
  }
  case object WD extends zio.aws.ssmsap.model.ComponentType {
    override def unwrap
        : software.amazon.awssdk.services.ssmsap.model.ComponentType =
      software.amazon.awssdk.services.ssmsap.model.ComponentType.WD
  }
  case object ERS extends zio.aws.ssmsap.model.ComponentType {
    override def unwrap
        : software.amazon.awssdk.services.ssmsap.model.ComponentType =
      software.amazon.awssdk.services.ssmsap.model.ComponentType.ERS
  }
}
