package zio.aws.ssmsap.model
import zio.aws.ssmsap.model.primitives.{
  AppRegistryArn,
  SsmSapArn,
  ApplicationId
}
import zio.ZIO
import zio.aws.core.{AwsError, BuilderHelper}
import zio.prelude.data.Optional
import scala.jdk.CollectionConverters.*
final case class GetApplicationRequest(
    applicationId: Optional[ApplicationId] = Optional.Absent,
    applicationArn: Optional[SsmSapArn] = Optional.Absent,
    appRegistryArn: Optional[AppRegistryArn] = Optional.Absent
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.ssmsap.model.GetApplicationRequest = {
    import GetApplicationRequest.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.ssmsap.model.GetApplicationRequest
      .builder()
      .optionallyWith(
        applicationId.map(value =>
          ApplicationId.unwrap(value): java.lang.String
        )
      )(_.applicationId)
      .optionallyWith(
        applicationArn.map(value => SsmSapArn.unwrap(value): java.lang.String)
      )(_.applicationArn)
      .optionallyWith(
        appRegistryArn.map(value =>
          AppRegistryArn.unwrap(value): java.lang.String
        )
      )(_.appRegistryArn)
      .build()
  }
  def asReadOnly: zio.aws.ssmsap.model.GetApplicationRequest.ReadOnly =
    zio.aws.ssmsap.model.GetApplicationRequest.wrap(buildAwsValue())
}
object GetApplicationRequest {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.ssmsap.model.GetApplicationRequest
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.ssmsap.model.GetApplicationRequest =
      zio.aws.ssmsap.model.GetApplicationRequest(
        applicationId.map(value => value),
        applicationArn.map(value => value),
        appRegistryArn.map(value => value)
      )
    def applicationId: Optional[ApplicationId]
    def applicationArn: Optional[SsmSapArn]
    def appRegistryArn: Optional[AppRegistryArn]
    def getApplicationId: ZIO[Any, AwsError, ApplicationId] =
      AwsError.unwrapOptionField("applicationId", applicationId)
    def getApplicationArn: ZIO[Any, AwsError, SsmSapArn] =
      AwsError.unwrapOptionField("applicationArn", applicationArn)
    def getAppRegistryArn: ZIO[Any, AwsError, AppRegistryArn] =
      AwsError.unwrapOptionField("appRegistryArn", appRegistryArn)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.ssmsap.model.GetApplicationRequest
  ) extends zio.aws.ssmsap.model.GetApplicationRequest.ReadOnly {
    override val applicationId: Optional[ApplicationId] = zio.aws.core.internal
      .optionalFromNullable(impl.applicationId())
      .map(value => zio.aws.ssmsap.model.primitives.ApplicationId(value))
    override val applicationArn: Optional[SsmSapArn] = zio.aws.core.internal
      .optionalFromNullable(impl.applicationArn())
      .map(value => zio.aws.ssmsap.model.primitives.SsmSapArn(value))
    override val appRegistryArn: Optional[AppRegistryArn] =
      zio.aws.core.internal
        .optionalFromNullable(impl.appRegistryArn())
        .map(value => zio.aws.ssmsap.model.primitives.AppRegistryArn(value))
  }
  def wrap(
      impl: software.amazon.awssdk.services.ssmsap.model.GetApplicationRequest
  ): zio.aws.ssmsap.model.GetApplicationRequest.ReadOnly = new Wrapper(impl)
}
