package zio.aws.ssmsap.model
import zio.aws.ssmsap.model.primitives.ApplicationId
import zio.ZIO
import zio.aws.core.{AwsError, BuilderHelper}
import zio.prelude.data.Optional
import scala.jdk.CollectionConverters.*
final case class UpdateApplicationSettingsRequest(
    applicationId: ApplicationId,
    credentialsToAddOrUpdate: Optional[
      Iterable[zio.aws.ssmsap.model.ApplicationCredential]
    ] = Optional.Absent,
    credentialsToRemove: Optional[
      Iterable[zio.aws.ssmsap.model.ApplicationCredential]
    ] = Optional.Absent
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.ssmsap.model.UpdateApplicationSettingsRequest = {
    import UpdateApplicationSettingsRequest.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.ssmsap.model.UpdateApplicationSettingsRequest
      .builder()
      .applicationId(ApplicationId.unwrap(applicationId): java.lang.String)
      .optionallyWith(
        credentialsToAddOrUpdate.map(value =>
          value.map { item =>
            item.buildAwsValue()
          }.asJavaCollection
        )
      )(_.credentialsToAddOrUpdate)
      .optionallyWith(
        credentialsToRemove.map(value =>
          value.map { item =>
            item.buildAwsValue()
          }.asJavaCollection
        )
      )(_.credentialsToRemove)
      .build()
  }
  def asReadOnly
      : zio.aws.ssmsap.model.UpdateApplicationSettingsRequest.ReadOnly =
    zio.aws.ssmsap.model.UpdateApplicationSettingsRequest.wrap(buildAwsValue())
}
object UpdateApplicationSettingsRequest {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.ssmsap.model.UpdateApplicationSettingsRequest
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.ssmsap.model.UpdateApplicationSettingsRequest =
      zio.aws.ssmsap.model.UpdateApplicationSettingsRequest(
        applicationId,
        credentialsToAddOrUpdate.map(value =>
          value.map { item =>
            item.asEditable
          }
        ),
        credentialsToRemove.map(value =>
          value.map { item =>
            item.asEditable
          }
        )
      )
    def applicationId: ApplicationId
    def credentialsToAddOrUpdate
        : Optional[List[zio.aws.ssmsap.model.ApplicationCredential.ReadOnly]]
    def credentialsToRemove
        : Optional[List[zio.aws.ssmsap.model.ApplicationCredential.ReadOnly]]
    def getApplicationId: ZIO[Any, Nothing, ApplicationId] =
      ZIO.succeed(applicationId)
    def getCredentialsToAddOrUpdate: ZIO[Any, AwsError, List[
      zio.aws.ssmsap.model.ApplicationCredential.ReadOnly
    ]] = AwsError.unwrapOptionField(
      "credentialsToAddOrUpdate",
      credentialsToAddOrUpdate
    )
    def getCredentialsToRemove: ZIO[Any, AwsError, List[
      zio.aws.ssmsap.model.ApplicationCredential.ReadOnly
    ]] = AwsError.unwrapOptionField("credentialsToRemove", credentialsToRemove)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.ssmsap.model.UpdateApplicationSettingsRequest
  ) extends zio.aws.ssmsap.model.UpdateApplicationSettingsRequest.ReadOnly {
    override val applicationId: ApplicationId =
      zio.aws.ssmsap.model.primitives.ApplicationId(impl.applicationId())
    override val credentialsToAddOrUpdate
        : Optional[List[zio.aws.ssmsap.model.ApplicationCredential.ReadOnly]] =
      zio.aws.core.internal
        .optionalFromNullable(impl.credentialsToAddOrUpdate())
        .map(value =>
          value.asScala.map { item =>
            zio.aws.ssmsap.model.ApplicationCredential.wrap(item)
          }.toList
        )
    override val credentialsToRemove
        : Optional[List[zio.aws.ssmsap.model.ApplicationCredential.ReadOnly]] =
      zio.aws.core.internal
        .optionalFromNullable(impl.credentialsToRemove())
        .map(value =>
          value.asScala.map { item =>
            zio.aws.ssmsap.model.ApplicationCredential.wrap(item)
          }.toList
        )
  }
  def wrap(
      impl: software.amazon.awssdk.services.ssmsap.model.UpdateApplicationSettingsRequest
  ): zio.aws.ssmsap.model.UpdateApplicationSettingsRequest.ReadOnly =
    new Wrapper(impl)
}
