package zio.aws.ssmsap.model
import zio.ZIO
import zio.aws.core.{AwsError, BuilderHelper}
import zio.prelude.data.Optional
import scala.jdk.CollectionConverters.*
final case class GetComponentResponse(
    component: Optional[zio.aws.ssmsap.model.Component] = Optional.Absent
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.ssmsap.model.GetComponentResponse = {
    import GetComponentResponse.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.ssmsap.model.GetComponentResponse
      .builder()
      .optionallyWith(component.map(value => value.buildAwsValue()))(
        _.component
      )
      .build()
  }
  def asReadOnly: zio.aws.ssmsap.model.GetComponentResponse.ReadOnly =
    zio.aws.ssmsap.model.GetComponentResponse.wrap(buildAwsValue())
}
object GetComponentResponse {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.ssmsap.model.GetComponentResponse
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.ssmsap.model.GetComponentResponse =
      zio.aws.ssmsap.model
        .GetComponentResponse(component.map(value => value.asEditable))
    def component: Optional[zio.aws.ssmsap.model.Component.ReadOnly]
    def getComponent
        : ZIO[Any, AwsError, zio.aws.ssmsap.model.Component.ReadOnly] =
      AwsError.unwrapOptionField("component", component)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.ssmsap.model.GetComponentResponse
  ) extends zio.aws.ssmsap.model.GetComponentResponse.ReadOnly {
    override val component: Optional[zio.aws.ssmsap.model.Component.ReadOnly] =
      zio.aws.core.internal
        .optionalFromNullable(impl.component())
        .map(value => zio.aws.ssmsap.model.Component.wrap(value))
  }
  def wrap(
      impl: software.amazon.awssdk.services.ssmsap.model.GetComponentResponse
  ): zio.aws.ssmsap.model.GetComponentResponse.ReadOnly = new Wrapper(impl)
}
