package zio.aws.ssmsap.model
import zio.aws.ssmsap.model.primitives.ApplicationId
import zio.ZIO
import zio.aws.core.BuilderHelper
import scala.jdk.CollectionConverters.*
final case class DeregisterApplicationRequest(applicationId: ApplicationId) {
  def buildAwsValue()
      : software.amazon.awssdk.services.ssmsap.model.DeregisterApplicationRequest = {
    import DeregisterApplicationRequest.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.ssmsap.model.DeregisterApplicationRequest
      .builder()
      .applicationId(ApplicationId.unwrap(applicationId): java.lang.String)
      .build()
  }
  def asReadOnly: zio.aws.ssmsap.model.DeregisterApplicationRequest.ReadOnly =
    zio.aws.ssmsap.model.DeregisterApplicationRequest.wrap(buildAwsValue())
}
object DeregisterApplicationRequest {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.ssmsap.model.DeregisterApplicationRequest
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.ssmsap.model.DeregisterApplicationRequest =
      zio.aws.ssmsap.model.DeregisterApplicationRequest(applicationId)
    def applicationId: ApplicationId
    def getApplicationId: ZIO[Any, Nothing, ApplicationId] =
      ZIO.succeed(applicationId)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.ssmsap.model.DeregisterApplicationRequest
  ) extends zio.aws.ssmsap.model.DeregisterApplicationRequest.ReadOnly {
    override val applicationId: ApplicationId =
      zio.aws.ssmsap.model.primitives.ApplicationId(impl.applicationId())
  }
  def wrap(
      impl: software.amazon.awssdk.services.ssmsap.model.DeregisterApplicationRequest
  ): zio.aws.ssmsap.model.DeregisterApplicationRequest.ReadOnly = new Wrapper(
    impl
  )
}
