package zio.aws.ssmsap.model
import scala.jdk.CollectionConverters.*
sealed trait ComponentStatus {
  def unwrap: software.amazon.awssdk.services.ssmsap.model.ComponentStatus
}
object ComponentStatus {
  def wrap(
      value: software.amazon.awssdk.services.ssmsap.model.ComponentStatus
  ): zio.aws.ssmsap.model.ComponentStatus = value match {
    case software.amazon.awssdk.services.ssmsap.model.ComponentStatus.UNKNOWN_TO_SDK_VERSION =>
      val r = unknownToSdkVersion
      r
    case software.amazon.awssdk.services.ssmsap.model.ComponentStatus.ACTIVATED =>
      val r = ACTIVATED
      r
  }
  case object unknownToSdkVersion extends zio.aws.ssmsap.model.ComponentStatus {
    override def unwrap
        : software.amazon.awssdk.services.ssmsap.model.ComponentStatus =
      software.amazon.awssdk.services.ssmsap.model.ComponentStatus.UNKNOWN_TO_SDK_VERSION
  }
  case object ACTIVATED extends zio.aws.ssmsap.model.ComponentStatus {
    override def unwrap
        : software.amazon.awssdk.services.ssmsap.model.ComponentStatus =
      software.amazon.awssdk.services.ssmsap.model.ComponentStatus.ACTIVATED
  }
}
