package zio.aws.ssmsap.model
import java.time.Instant
import zio.prelude.data.Optional
import zio.aws.core.{AwsError, BuilderHelper}
import zio.ZIO
import zio.aws.ssmsap.model.primitives.{
  OperationId,
  Timestamp,
  OperationType,
  Arn,
  ResourceType,
  ResourceId
}
import scala.jdk.CollectionConverters.*
final case class Operation(
    id: Optional[OperationId] = Optional.Absent,
    `type`: Optional[OperationType] = Optional.Absent,
    status: Optional[zio.aws.ssmsap.model.OperationStatus] = Optional.Absent,
    statusMessage: Optional[String] = Optional.Absent,
    properties: Optional[Map[String, String]] = Optional.Absent,
    resourceType: Optional[ResourceType] = Optional.Absent,
    resourceId: Optional[ResourceId] = Optional.Absent,
    resourceArn: Optional[Arn] = Optional.Absent,
    startTime: Optional[Timestamp] = Optional.Absent,
    endTime: Optional[Timestamp] = Optional.Absent,
    lastUpdatedTime: Optional[Timestamp] = Optional.Absent
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.ssmsap.model.Operation = {
    import Operation.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.ssmsap.model.Operation
      .builder()
      .optionallyWith(
        id.map(value => OperationId.unwrap(value): java.lang.String)
      )(_.id)
      .optionallyWith(
        `type`.map(value => OperationType.unwrap(value): java.lang.String)
      )(_.`type`)
      .optionallyWith(status.map(value => value.unwrap))(_.status)
      .optionallyWith(statusMessage.map(value => value: java.lang.String))(
        _.statusMessage
      )
      .optionallyWith(
        properties.map(value =>
          value
            .map({ case (key, value) =>
              (key: java.lang.String) -> (value: java.lang.String)
            })
            .asJava
        )
      )(_.properties)
      .optionallyWith(
        resourceType.map(value => ResourceType.unwrap(value): java.lang.String)
      )(_.resourceType)
      .optionallyWith(
        resourceId.map(value => ResourceId.unwrap(value): java.lang.String)
      )(_.resourceId)
      .optionallyWith(
        resourceArn.map(value => Arn.unwrap(value): java.lang.String)
      )(_.resourceArn)
      .optionallyWith(startTime.map(value => Timestamp.unwrap(value): Instant))(
        _.startTime
      )
      .optionallyWith(endTime.map(value => Timestamp.unwrap(value): Instant))(
        _.endTime
      )
      .optionallyWith(
        lastUpdatedTime.map(value => Timestamp.unwrap(value): Instant)
      )(_.lastUpdatedTime)
      .build()
  }
  def asReadOnly: zio.aws.ssmsap.model.Operation.ReadOnly =
    zio.aws.ssmsap.model.Operation.wrap(buildAwsValue())
}
object Operation {
  private lazy val zioAwsBuilderHelper
      : BuilderHelper[software.amazon.awssdk.services.ssmsap.model.Operation] =
    BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.ssmsap.model.Operation =
      zio.aws.ssmsap.model.Operation(
        id.map(value => value),
        `type`.map(value => value),
        status.map(value => value),
        statusMessage.map(value => value),
        properties.map(value => value),
        resourceType.map(value => value),
        resourceId.map(value => value),
        resourceArn.map(value => value),
        startTime.map(value => value),
        endTime.map(value => value),
        lastUpdatedTime.map(value => value)
      )
    def id: Optional[OperationId]
    def `type`: Optional[OperationType]
    def status: Optional[zio.aws.ssmsap.model.OperationStatus]
    def statusMessage: Optional[String]
    def properties: Optional[Map[String, String]]
    def resourceType: Optional[ResourceType]
    def resourceId: Optional[ResourceId]
    def resourceArn: Optional[Arn]
    def startTime: Optional[Timestamp]
    def endTime: Optional[Timestamp]
    def lastUpdatedTime: Optional[Timestamp]
    def getId: ZIO[Any, AwsError, OperationId] =
      AwsError.unwrapOptionField("id", id)
    def getType: ZIO[Any, AwsError, OperationType] =
      AwsError.unwrapOptionField("type", `type`)
    def getStatus: ZIO[Any, AwsError, zio.aws.ssmsap.model.OperationStatus] =
      AwsError.unwrapOptionField("status", status)
    def getStatusMessage: ZIO[Any, AwsError, String] =
      AwsError.unwrapOptionField("statusMessage", statusMessage)
    def getProperties: ZIO[Any, AwsError, Map[String, String]] =
      AwsError.unwrapOptionField("properties", properties)
    def getResourceType: ZIO[Any, AwsError, ResourceType] =
      AwsError.unwrapOptionField("resourceType", resourceType)
    def getResourceId: ZIO[Any, AwsError, ResourceId] =
      AwsError.unwrapOptionField("resourceId", resourceId)
    def getResourceArn: ZIO[Any, AwsError, Arn] =
      AwsError.unwrapOptionField("resourceArn", resourceArn)
    def getStartTime: ZIO[Any, AwsError, Timestamp] =
      AwsError.unwrapOptionField("startTime", startTime)
    def getEndTime: ZIO[Any, AwsError, Timestamp] =
      AwsError.unwrapOptionField("endTime", endTime)
    def getLastUpdatedTime: ZIO[Any, AwsError, Timestamp] =
      AwsError.unwrapOptionField("lastUpdatedTime", lastUpdatedTime)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.ssmsap.model.Operation
  ) extends zio.aws.ssmsap.model.Operation.ReadOnly {
    override val id: Optional[OperationId] = zio.aws.core.internal
      .optionalFromNullable(impl.id())
      .map(value => zio.aws.ssmsap.model.primitives.OperationId(value))
    override val `type`: Optional[OperationType] = zio.aws.core.internal
      .optionalFromNullable(impl.`type`())
      .map(value => zio.aws.ssmsap.model.primitives.OperationType(value))
    override val status: Optional[zio.aws.ssmsap.model.OperationStatus] =
      zio.aws.core.internal
        .optionalFromNullable(impl.status())
        .map(value => zio.aws.ssmsap.model.OperationStatus.wrap(value))
    override val statusMessage: Optional[String] = zio.aws.core.internal
      .optionalFromNullable(impl.statusMessage())
      .map(value => value: String)
    override val properties: Optional[Map[String, String]] =
      zio.aws.core.internal
        .optionalFromNullable(impl.properties())
        .map(value =>
          value.asScala
            .map({ case (key, value) =>
              (key: String) -> (value: String)
            })
            .toMap
        )
    override val resourceType: Optional[ResourceType] = zio.aws.core.internal
      .optionalFromNullable(impl.resourceType())
      .map(value => zio.aws.ssmsap.model.primitives.ResourceType(value))
    override val resourceId: Optional[ResourceId] = zio.aws.core.internal
      .optionalFromNullable(impl.resourceId())
      .map(value => zio.aws.ssmsap.model.primitives.ResourceId(value))
    override val resourceArn: Optional[Arn] = zio.aws.core.internal
      .optionalFromNullable(impl.resourceArn())
      .map(value => zio.aws.ssmsap.model.primitives.Arn(value))
    override val startTime: Optional[Timestamp] = zio.aws.core.internal
      .optionalFromNullable(impl.startTime())
      .map(value => zio.aws.ssmsap.model.primitives.Timestamp(value))
    override val endTime: Optional[Timestamp] = zio.aws.core.internal
      .optionalFromNullable(impl.endTime())
      .map(value => zio.aws.ssmsap.model.primitives.Timestamp(value))
    override val lastUpdatedTime: Optional[Timestamp] = zio.aws.core.internal
      .optionalFromNullable(impl.lastUpdatedTime())
      .map(value => zio.aws.ssmsap.model.primitives.Timestamp(value))
  }
  def wrap(
      impl: software.amazon.awssdk.services.ssmsap.model.Operation
  ): zio.aws.ssmsap.model.Operation.ReadOnly = new Wrapper(impl)
}
