package zio.aws.ssmsap.model
import zio.aws.ssmsap.model.primitives.ApplicationId
import zio.ZIO
import zio.aws.core.{AwsError, BuilderHelper}
import zio.prelude.data.Optional
import scala.jdk.CollectionConverters.*
final case class UpdateApplicationSettingsRequest(
    applicationId: ApplicationId,
    credentialsToAddOrUpdate: Optional[
      Iterable[zio.aws.ssmsap.model.ApplicationCredential]
    ] = Optional.Absent,
    credentialsToRemove: Optional[
      Iterable[zio.aws.ssmsap.model.ApplicationCredential]
    ] = Optional.Absent,
    backint: Optional[zio.aws.ssmsap.model.BackintConfig] = Optional.Absent
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.ssmsap.model.UpdateApplicationSettingsRequest = {
    import UpdateApplicationSettingsRequest.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.ssmsap.model.UpdateApplicationSettingsRequest
      .builder()
      .applicationId(ApplicationId.unwrap(applicationId): java.lang.String)
      .optionallyWith(
        credentialsToAddOrUpdate.map(value =>
          value.map { item =>
            item.buildAwsValue()
          }.asJavaCollection
        )
      )(_.credentialsToAddOrUpdate)
      .optionallyWith(
        credentialsToRemove.map(value =>
          value.map { item =>
            item.buildAwsValue()
          }.asJavaCollection
        )
      )(_.credentialsToRemove)
      .optionallyWith(backint.map(value => value.buildAwsValue()))(_.backint)
      .build()
  }
  def asReadOnly
      : zio.aws.ssmsap.model.UpdateApplicationSettingsRequest.ReadOnly =
    zio.aws.ssmsap.model.UpdateApplicationSettingsRequest.wrap(buildAwsValue())
}
object UpdateApplicationSettingsRequest {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.ssmsap.model.UpdateApplicationSettingsRequest
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.ssmsap.model.UpdateApplicationSettingsRequest =
      zio.aws.ssmsap.model.UpdateApplicationSettingsRequest(
        applicationId,
        credentialsToAddOrUpdate.map(value =>
          value.map { item =>
            item.asEditable
          }
        ),
        credentialsToRemove.map(value =>
          value.map { item =>
            item.asEditable
          }
        ),
        backint.map(value => value.asEditable)
      )
    def applicationId: ApplicationId
    def credentialsToAddOrUpdate
        : Optional[List[zio.aws.ssmsap.model.ApplicationCredential.ReadOnly]]
    def credentialsToRemove
        : Optional[List[zio.aws.ssmsap.model.ApplicationCredential.ReadOnly]]
    def backint: Optional[zio.aws.ssmsap.model.BackintConfig.ReadOnly]
    def getApplicationId: ZIO[Any, Nothing, ApplicationId] =
      ZIO.succeed(applicationId)
    def getCredentialsToAddOrUpdate: ZIO[Any, AwsError, List[
      zio.aws.ssmsap.model.ApplicationCredential.ReadOnly
    ]] = AwsError.unwrapOptionField(
      "credentialsToAddOrUpdate",
      credentialsToAddOrUpdate
    )
    def getCredentialsToRemove: ZIO[Any, AwsError, List[
      zio.aws.ssmsap.model.ApplicationCredential.ReadOnly
    ]] = AwsError.unwrapOptionField("credentialsToRemove", credentialsToRemove)
    def getBackint
        : ZIO[Any, AwsError, zio.aws.ssmsap.model.BackintConfig.ReadOnly] =
      AwsError.unwrapOptionField("backint", backint)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.ssmsap.model.UpdateApplicationSettingsRequest
  ) extends zio.aws.ssmsap.model.UpdateApplicationSettingsRequest.ReadOnly {
    override val applicationId: ApplicationId =
      zio.aws.ssmsap.model.primitives.ApplicationId(impl.applicationId())
    override val credentialsToAddOrUpdate
        : Optional[List[zio.aws.ssmsap.model.ApplicationCredential.ReadOnly]] =
      zio.aws.core.internal
        .optionalFromNullable(impl.credentialsToAddOrUpdate())
        .map(value =>
          value.asScala.map { item =>
            zio.aws.ssmsap.model.ApplicationCredential.wrap(item)
          }.toList
        )
    override val credentialsToRemove
        : Optional[List[zio.aws.ssmsap.model.ApplicationCredential.ReadOnly]] =
      zio.aws.core.internal
        .optionalFromNullable(impl.credentialsToRemove())
        .map(value =>
          value.asScala.map { item =>
            zio.aws.ssmsap.model.ApplicationCredential.wrap(item)
          }.toList
        )
    override val backint
        : Optional[zio.aws.ssmsap.model.BackintConfig.ReadOnly] =
      zio.aws.core.internal
        .optionalFromNullable(impl.backint())
        .map(value => zio.aws.ssmsap.model.BackintConfig.wrap(value))
  }
  def wrap(
      impl: software.amazon.awssdk.services.ssmsap.model.UpdateApplicationSettingsRequest
  ): zio.aws.ssmsap.model.UpdateApplicationSettingsRequest.ReadOnly =
    new Wrapper(impl)
}
