package zio.aws.ssmsap.model
import scala.jdk.CollectionConverters.*
sealed trait FilterOperator {
  def unwrap: software.amazon.awssdk.services.ssmsap.model.FilterOperator
}
object FilterOperator {
  def wrap(
      value: software.amazon.awssdk.services.ssmsap.model.FilterOperator
  ): zio.aws.ssmsap.model.FilterOperator = value match {
    case software.amazon.awssdk.services.ssmsap.model.FilterOperator.UNKNOWN_TO_SDK_VERSION =>
      val r = unknownToSdkVersion
      r
    case software.amazon.awssdk.services.ssmsap.model.FilterOperator.EQUALS =>
      val r = Equals
      r
    case software.amazon.awssdk.services.ssmsap.model.FilterOperator.GREATER_THAN_OR_EQUALS =>
      val r = GreaterThanOrEquals
      r
    case software.amazon.awssdk.services.ssmsap.model.FilterOperator.LESS_THAN_OR_EQUALS =>
      val r = LessThanOrEquals
      r
  }
  case object unknownToSdkVersion extends zio.aws.ssmsap.model.FilterOperator {
    override def unwrap
        : software.amazon.awssdk.services.ssmsap.model.FilterOperator =
      software.amazon.awssdk.services.ssmsap.model.FilterOperator.UNKNOWN_TO_SDK_VERSION
  }
  case object Equals extends zio.aws.ssmsap.model.FilterOperator {
    override def unwrap
        : software.amazon.awssdk.services.ssmsap.model.FilterOperator =
      software.amazon.awssdk.services.ssmsap.model.FilterOperator.EQUALS
  }
  case object GreaterThanOrEquals extends zio.aws.ssmsap.model.FilterOperator {
    override def unwrap
        : software.amazon.awssdk.services.ssmsap.model.FilterOperator =
      software.amazon.awssdk.services.ssmsap.model.FilterOperator.GREATER_THAN_OR_EQUALS
  }
  case object LessThanOrEquals extends zio.aws.ssmsap.model.FilterOperator {
    override def unwrap
        : software.amazon.awssdk.services.ssmsap.model.FilterOperator =
      software.amazon.awssdk.services.ssmsap.model.FilterOperator.LESS_THAN_OR_EQUALS
  }
}
