package zio.aws.ssmsap.model
import java.time.Instant
import zio.prelude.data.Optional
import zio.aws.core.{AwsError, BuilderHelper}
import zio.ZIO
import zio.aws.ssmsap.model.primitives.{
  DatabaseId,
  SsmSapArn,
  Timestamp,
  ComponentId,
  Integer,
  ApplicationId
}
import scala.jdk.CollectionConverters.*
final case class Database(
    applicationId: Optional[ApplicationId] = Optional.Absent,
    componentId: Optional[ComponentId] = Optional.Absent,
    credentials: Optional[
      Iterable[zio.aws.ssmsap.model.ApplicationCredential]
    ] = Optional.Absent,
    databaseId: Optional[DatabaseId] = Optional.Absent,
    databaseName: Optional[String] = Optional.Absent,
    databaseType: Optional[zio.aws.ssmsap.model.DatabaseType] = Optional.Absent,
    arn: Optional[SsmSapArn] = Optional.Absent,
    status: Optional[zio.aws.ssmsap.model.DatabaseStatus] = Optional.Absent,
    primaryHost: Optional[String] = Optional.Absent,
    sqlPort: Optional[Integer] = Optional.Absent,
    lastUpdated: Optional[Timestamp] = Optional.Absent
) {
  def buildAwsValue(): software.amazon.awssdk.services.ssmsap.model.Database = {
    import Database.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.ssmsap.model.Database
      .builder()
      .optionallyWith(
        applicationId.map(value =>
          ApplicationId.unwrap(value): java.lang.String
        )
      )(_.applicationId)
      .optionallyWith(
        componentId.map(value => ComponentId.unwrap(value): java.lang.String)
      )(_.componentId)
      .optionallyWith(
        credentials.map(value =>
          value.map { item =>
            item.buildAwsValue()
          }.asJavaCollection
        )
      )(_.credentials)
      .optionallyWith(
        databaseId.map(value => DatabaseId.unwrap(value): java.lang.String)
      )(_.databaseId)
      .optionallyWith(databaseName.map(value => value: java.lang.String))(
        _.databaseName
      )
      .optionallyWith(databaseType.map(value => value.unwrap))(_.databaseType)
      .optionallyWith(
        arn.map(value => SsmSapArn.unwrap(value): java.lang.String)
      )(_.arn)
      .optionallyWith(status.map(value => value.unwrap))(_.status)
      .optionallyWith(primaryHost.map(value => value: java.lang.String))(
        _.primaryHost
      )
      .optionallyWith(sqlPort.map(value => value: java.lang.Integer))(_.sqlPort)
      .optionallyWith(
        lastUpdated.map(value => Timestamp.unwrap(value): Instant)
      )(_.lastUpdated)
      .build()
  }
  def asReadOnly: zio.aws.ssmsap.model.Database.ReadOnly =
    zio.aws.ssmsap.model.Database.wrap(buildAwsValue())
}
object Database {
  private lazy val zioAwsBuilderHelper
      : BuilderHelper[software.amazon.awssdk.services.ssmsap.model.Database] =
    BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.ssmsap.model.Database =
      zio.aws.ssmsap.model.Database(
        applicationId.map(value => value),
        componentId.map(value => value),
        credentials.map(value =>
          value.map { item =>
            item.asEditable
          }
        ),
        databaseId.map(value => value),
        databaseName.map(value => value),
        databaseType.map(value => value),
        arn.map(value => value),
        status.map(value => value),
        primaryHost.map(value => value),
        sqlPort.map(value => value),
        lastUpdated.map(value => value)
      )
    def applicationId: Optional[ApplicationId]
    def componentId: Optional[ComponentId]
    def credentials
        : Optional[List[zio.aws.ssmsap.model.ApplicationCredential.ReadOnly]]
    def databaseId: Optional[DatabaseId]
    def databaseName: Optional[String]
    def databaseType: Optional[zio.aws.ssmsap.model.DatabaseType]
    def arn: Optional[SsmSapArn]
    def status: Optional[zio.aws.ssmsap.model.DatabaseStatus]
    def primaryHost: Optional[String]
    def sqlPort: Optional[Integer]
    def lastUpdated: Optional[Timestamp]
    def getApplicationId: ZIO[Any, AwsError, ApplicationId] =
      AwsError.unwrapOptionField("applicationId", applicationId)
    def getComponentId: ZIO[Any, AwsError, ComponentId] =
      AwsError.unwrapOptionField("componentId", componentId)
    def getCredentials: ZIO[Any, AwsError, List[
      zio.aws.ssmsap.model.ApplicationCredential.ReadOnly
    ]] = AwsError.unwrapOptionField("credentials", credentials)
    def getDatabaseId: ZIO[Any, AwsError, DatabaseId] =
      AwsError.unwrapOptionField("databaseId", databaseId)
    def getDatabaseName: ZIO[Any, AwsError, String] =
      AwsError.unwrapOptionField("databaseName", databaseName)
    def getDatabaseType: ZIO[Any, AwsError, zio.aws.ssmsap.model.DatabaseType] =
      AwsError.unwrapOptionField("databaseType", databaseType)
    def getArn: ZIO[Any, AwsError, SsmSapArn] =
      AwsError.unwrapOptionField("arn", arn)
    def getStatus: ZIO[Any, AwsError, zio.aws.ssmsap.model.DatabaseStatus] =
      AwsError.unwrapOptionField("status", status)
    def getPrimaryHost: ZIO[Any, AwsError, String] =
      AwsError.unwrapOptionField("primaryHost", primaryHost)
    def getSqlPort: ZIO[Any, AwsError, Integer] =
      AwsError.unwrapOptionField("sqlPort", sqlPort)
    def getLastUpdated: ZIO[Any, AwsError, Timestamp] =
      AwsError.unwrapOptionField("lastUpdated", lastUpdated)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.ssmsap.model.Database
  ) extends zio.aws.ssmsap.model.Database.ReadOnly {
    override val applicationId: Optional[ApplicationId] = zio.aws.core.internal
      .optionalFromNullable(impl.applicationId())
      .map(value => zio.aws.ssmsap.model.primitives.ApplicationId(value))
    override val componentId: Optional[ComponentId] = zio.aws.core.internal
      .optionalFromNullable(impl.componentId())
      .map(value => zio.aws.ssmsap.model.primitives.ComponentId(value))
    override val credentials
        : Optional[List[zio.aws.ssmsap.model.ApplicationCredential.ReadOnly]] =
      zio.aws.core.internal
        .optionalFromNullable(impl.credentials())
        .map(value =>
          value.asScala.map { item =>
            zio.aws.ssmsap.model.ApplicationCredential.wrap(item)
          }.toList
        )
    override val databaseId: Optional[DatabaseId] = zio.aws.core.internal
      .optionalFromNullable(impl.databaseId())
      .map(value => zio.aws.ssmsap.model.primitives.DatabaseId(value))
    override val databaseName: Optional[String] = zio.aws.core.internal
      .optionalFromNullable(impl.databaseName())
      .map(value => value: String)
    override val databaseType: Optional[zio.aws.ssmsap.model.DatabaseType] =
      zio.aws.core.internal
        .optionalFromNullable(impl.databaseType())
        .map(value => zio.aws.ssmsap.model.DatabaseType.wrap(value))
    override val arn: Optional[SsmSapArn] = zio.aws.core.internal
      .optionalFromNullable(impl.arn())
      .map(value => zio.aws.ssmsap.model.primitives.SsmSapArn(value))
    override val status: Optional[zio.aws.ssmsap.model.DatabaseStatus] =
      zio.aws.core.internal
        .optionalFromNullable(impl.status())
        .map(value => zio.aws.ssmsap.model.DatabaseStatus.wrap(value))
    override val primaryHost: Optional[String] = zio.aws.core.internal
      .optionalFromNullable(impl.primaryHost())
      .map(value => value: String)
    override val sqlPort: Optional[Integer] = zio.aws.core.internal
      .optionalFromNullable(impl.sqlPort())
      .map(value => value: Integer)
    override val lastUpdated: Optional[Timestamp] = zio.aws.core.internal
      .optionalFromNullable(impl.lastUpdated())
      .map(value => zio.aws.ssmsap.model.primitives.Timestamp(value))
  }
  def wrap(
      impl: software.amazon.awssdk.services.ssmsap.model.Database
  ): zio.aws.ssmsap.model.Database.ReadOnly = new Wrapper(impl)
}
