package zio.aws.ssmsap.model
import scala.jdk.CollectionConverters.*
sealed trait ClusterStatus {
  def unwrap: software.amazon.awssdk.services.ssmsap.model.ClusterStatus
}
object ClusterStatus {
  def wrap(
      value: software.amazon.awssdk.services.ssmsap.model.ClusterStatus
  ): zio.aws.ssmsap.model.ClusterStatus = value match {
    case software.amazon.awssdk.services.ssmsap.model.ClusterStatus.UNKNOWN_TO_SDK_VERSION =>
      val r = unknownToSdkVersion
      r
    case software.amazon.awssdk.services.ssmsap.model.ClusterStatus.ONLINE =>
      val r = ONLINE
      r
    case software.amazon.awssdk.services.ssmsap.model.ClusterStatus.STANDBY =>
      val r = STANDBY
      r
    case software.amazon.awssdk.services.ssmsap.model.ClusterStatus.MAINTENANCE =>
      val r = MAINTENANCE
      r
    case software.amazon.awssdk.services.ssmsap.model.ClusterStatus.OFFLINE =>
      val r = OFFLINE
      r
    case software.amazon.awssdk.services.ssmsap.model.ClusterStatus.NONE =>
      val r = NONE
      r
  }
  case object unknownToSdkVersion extends zio.aws.ssmsap.model.ClusterStatus {
    override def unwrap
        : software.amazon.awssdk.services.ssmsap.model.ClusterStatus =
      software.amazon.awssdk.services.ssmsap.model.ClusterStatus.UNKNOWN_TO_SDK_VERSION
  }
  case object ONLINE extends zio.aws.ssmsap.model.ClusterStatus {
    override def unwrap
        : software.amazon.awssdk.services.ssmsap.model.ClusterStatus =
      software.amazon.awssdk.services.ssmsap.model.ClusterStatus.ONLINE
  }
  case object STANDBY extends zio.aws.ssmsap.model.ClusterStatus {
    override def unwrap
        : software.amazon.awssdk.services.ssmsap.model.ClusterStatus =
      software.amazon.awssdk.services.ssmsap.model.ClusterStatus.STANDBY
  }
  case object MAINTENANCE extends zio.aws.ssmsap.model.ClusterStatus {
    override def unwrap
        : software.amazon.awssdk.services.ssmsap.model.ClusterStatus =
      software.amazon.awssdk.services.ssmsap.model.ClusterStatus.MAINTENANCE
  }
  case object OFFLINE extends zio.aws.ssmsap.model.ClusterStatus {
    override def unwrap
        : software.amazon.awssdk.services.ssmsap.model.ClusterStatus =
      software.amazon.awssdk.services.ssmsap.model.ClusterStatus.OFFLINE
  }
  case object NONE extends zio.aws.ssmsap.model.ClusterStatus {
    override def unwrap
        : software.amazon.awssdk.services.ssmsap.model.ClusterStatus =
      software.amazon.awssdk.services.ssmsap.model.ClusterStatus.NONE
  }
}
