package zio.aws.ssmsap.model
import scala.jdk.CollectionConverters.*
sealed trait HostRole {
  def unwrap: software.amazon.awssdk.services.ssmsap.model.HostRole
}
object HostRole {
  def wrap(
      value: software.amazon.awssdk.services.ssmsap.model.HostRole
  ): zio.aws.ssmsap.model.HostRole = value match {
    case software.amazon.awssdk.services.ssmsap.model.HostRole.UNKNOWN_TO_SDK_VERSION =>
      val r = unknownToSdkVersion
      r
    case software.amazon.awssdk.services.ssmsap.model.HostRole.LEADER =>
      val r = LEADER
      r
    case software.amazon.awssdk.services.ssmsap.model.HostRole.WORKER =>
      val r = WORKER
      r
    case software.amazon.awssdk.services.ssmsap.model.HostRole.STANDBY =>
      val r = STANDBY
      r
    case software.amazon.awssdk.services.ssmsap.model.HostRole.UNKNOWN =>
      val r = UNKNOWN
      r
  }
  case object unknownToSdkVersion extends zio.aws.ssmsap.model.HostRole {
    override def unwrap: software.amazon.awssdk.services.ssmsap.model.HostRole =
      software.amazon.awssdk.services.ssmsap.model.HostRole.UNKNOWN_TO_SDK_VERSION
  }
  case object LEADER extends zio.aws.ssmsap.model.HostRole {
    override def unwrap: software.amazon.awssdk.services.ssmsap.model.HostRole =
      software.amazon.awssdk.services.ssmsap.model.HostRole.LEADER
  }
  case object WORKER extends zio.aws.ssmsap.model.HostRole {
    override def unwrap: software.amazon.awssdk.services.ssmsap.model.HostRole =
      software.amazon.awssdk.services.ssmsap.model.HostRole.WORKER
  }
  case object STANDBY extends zio.aws.ssmsap.model.HostRole {
    override def unwrap: software.amazon.awssdk.services.ssmsap.model.HostRole =
      software.amazon.awssdk.services.ssmsap.model.HostRole.STANDBY
  }
  case object UNKNOWN extends zio.aws.ssmsap.model.HostRole {
    override def unwrap: software.amazon.awssdk.services.ssmsap.model.HostRole =
      software.amazon.awssdk.services.ssmsap.model.HostRole.UNKNOWN
  }
}
