package zio.aws.ssmsap.model
import scala.jdk.CollectionConverters.*
sealed trait ComponentStatus {
  def unwrap: software.amazon.awssdk.services.ssmsap.model.ComponentStatus
}
object ComponentStatus {
  def wrap(
      value: software.amazon.awssdk.services.ssmsap.model.ComponentStatus
  ): zio.aws.ssmsap.model.ComponentStatus = value match {
    case software.amazon.awssdk.services.ssmsap.model.ComponentStatus.UNKNOWN_TO_SDK_VERSION =>
      val r = unknownToSdkVersion
      r
    case software.amazon.awssdk.services.ssmsap.model.ComponentStatus.ACTIVATED =>
      val r = ACTIVATED
      r
    case software.amazon.awssdk.services.ssmsap.model.ComponentStatus.STARTING =>
      val r = STARTING
      r
    case software.amazon.awssdk.services.ssmsap.model.ComponentStatus.STOPPED =>
      val r = STOPPED
      r
    case software.amazon.awssdk.services.ssmsap.model.ComponentStatus.STOPPING =>
      val r = STOPPING
      r
    case software.amazon.awssdk.services.ssmsap.model.ComponentStatus.RUNNING =>
      val r = RUNNING
      r
    case software.amazon.awssdk.services.ssmsap.model.ComponentStatus.RUNNING_WITH_ERROR =>
      val r = RUNNING_WITH_ERROR
      r
    case software.amazon.awssdk.services.ssmsap.model.ComponentStatus.UNDEFINED =>
      val r = UNDEFINED
      r
  }
  case object unknownToSdkVersion extends zio.aws.ssmsap.model.ComponentStatus {
    override def unwrap
        : software.amazon.awssdk.services.ssmsap.model.ComponentStatus =
      software.amazon.awssdk.services.ssmsap.model.ComponentStatus.UNKNOWN_TO_SDK_VERSION
  }
  case object ACTIVATED extends zio.aws.ssmsap.model.ComponentStatus {
    override def unwrap
        : software.amazon.awssdk.services.ssmsap.model.ComponentStatus =
      software.amazon.awssdk.services.ssmsap.model.ComponentStatus.ACTIVATED
  }
  case object STARTING extends zio.aws.ssmsap.model.ComponentStatus {
    override def unwrap
        : software.amazon.awssdk.services.ssmsap.model.ComponentStatus =
      software.amazon.awssdk.services.ssmsap.model.ComponentStatus.STARTING
  }
  case object STOPPED extends zio.aws.ssmsap.model.ComponentStatus {
    override def unwrap
        : software.amazon.awssdk.services.ssmsap.model.ComponentStatus =
      software.amazon.awssdk.services.ssmsap.model.ComponentStatus.STOPPED
  }
  case object STOPPING extends zio.aws.ssmsap.model.ComponentStatus {
    override def unwrap
        : software.amazon.awssdk.services.ssmsap.model.ComponentStatus =
      software.amazon.awssdk.services.ssmsap.model.ComponentStatus.STOPPING
  }
  case object RUNNING extends zio.aws.ssmsap.model.ComponentStatus {
    override def unwrap
        : software.amazon.awssdk.services.ssmsap.model.ComponentStatus =
      software.amazon.awssdk.services.ssmsap.model.ComponentStatus.RUNNING
  }
  case object RUNNING_WITH_ERROR extends zio.aws.ssmsap.model.ComponentStatus {
    override def unwrap
        : software.amazon.awssdk.services.ssmsap.model.ComponentStatus =
      software.amazon.awssdk.services.ssmsap.model.ComponentStatus.RUNNING_WITH_ERROR
  }
  case object UNDEFINED extends zio.aws.ssmsap.model.ComponentStatus {
    override def unwrap
        : software.amazon.awssdk.services.ssmsap.model.ComponentStatus =
      software.amazon.awssdk.services.ssmsap.model.ComponentStatus.UNDEFINED
  }
}
