package zio.aws.ssmsap.model
import zio.aws.ssmsap.model.primitives.SsmSapArn
import zio.ZIO
import zio.aws.core.BuilderHelper
import scala.jdk.CollectionConverters.*
final case class ListTagsForResourceRequest(resourceArn: SsmSapArn) {
  def buildAwsValue()
      : software.amazon.awssdk.services.ssmsap.model.ListTagsForResourceRequest = {
    import ListTagsForResourceRequest.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.ssmsap.model.ListTagsForResourceRequest
      .builder()
      .resourceArn(SsmSapArn.unwrap(resourceArn): java.lang.String)
      .build()
  }
  def asReadOnly: zio.aws.ssmsap.model.ListTagsForResourceRequest.ReadOnly =
    zio.aws.ssmsap.model.ListTagsForResourceRequest.wrap(buildAwsValue())
}
object ListTagsForResourceRequest {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.ssmsap.model.ListTagsForResourceRequest
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.ssmsap.model.ListTagsForResourceRequest =
      zio.aws.ssmsap.model.ListTagsForResourceRequest(resourceArn)
    def resourceArn: SsmSapArn
    def getResourceArn: ZIO[Any, Nothing, SsmSapArn] = ZIO.succeed(resourceArn)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.ssmsap.model.ListTagsForResourceRequest
  ) extends zio.aws.ssmsap.model.ListTagsForResourceRequest.ReadOnly {
    override val resourceArn: SsmSapArn =
      zio.aws.ssmsap.model.primitives.SsmSapArn(impl.resourceArn())
  }
  def wrap(
      impl: software.amazon.awssdk.services.ssmsap.model.ListTagsForResourceRequest
  ): zio.aws.ssmsap.model.ListTagsForResourceRequest.ReadOnly = new Wrapper(
    impl
  )
}
