package zio.aws.ssmsap.model
import java.time.Instant
import zio.prelude.data.Optional
import zio.aws.core.{AwsError, BuilderHelper}
import zio.ZIO
import zio.aws.ssmsap.model.primitives.{
  SsmSapArn,
  Timestamp,
  ComponentId,
  AppRegistryArn,
  ApplicationId
}
import scala.jdk.CollectionConverters.*
final case class Application(
    id: Optional[ApplicationId] = Optional.Absent,
    `type`: Optional[zio.aws.ssmsap.model.ApplicationType] = Optional.Absent,
    arn: Optional[SsmSapArn] = Optional.Absent,
    appRegistryArn: Optional[AppRegistryArn] = Optional.Absent,
    status: Optional[zio.aws.ssmsap.model.ApplicationStatus] = Optional.Absent,
    components: Optional[Iterable[ComponentId]] = Optional.Absent,
    lastUpdated: Optional[Timestamp] = Optional.Absent,
    statusMessage: Optional[String] = Optional.Absent
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.ssmsap.model.Application = {
    import Application.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.ssmsap.model.Application
      .builder()
      .optionallyWith(
        id.map(value => ApplicationId.unwrap(value): java.lang.String)
      )(_.id)
      .optionallyWith(`type`.map(value => value.unwrap))(_.`type`)
      .optionallyWith(
        arn.map(value => SsmSapArn.unwrap(value): java.lang.String)
      )(_.arn)
      .optionallyWith(
        appRegistryArn.map(value =>
          AppRegistryArn.unwrap(value): java.lang.String
        )
      )(_.appRegistryArn)
      .optionallyWith(status.map(value => value.unwrap))(_.status)
      .optionallyWith(
        components.map(value =>
          value.map { item =>
            ComponentId.unwrap(item): java.lang.String
          }.asJavaCollection
        )
      )(_.components)
      .optionallyWith(
        lastUpdated.map(value => Timestamp.unwrap(value): Instant)
      )(_.lastUpdated)
      .optionallyWith(statusMessage.map(value => value: java.lang.String))(
        _.statusMessage
      )
      .build()
  }
  def asReadOnly: zio.aws.ssmsap.model.Application.ReadOnly =
    zio.aws.ssmsap.model.Application.wrap(buildAwsValue())
}
object Application {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.ssmsap.model.Application
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.ssmsap.model.Application =
      zio.aws.ssmsap.model.Application(
        id.map(value => value),
        `type`.map(value => value),
        arn.map(value => value),
        appRegistryArn.map(value => value),
        status.map(value => value),
        components.map(value => value),
        lastUpdated.map(value => value),
        statusMessage.map(value => value)
      )
    def id: Optional[ApplicationId]
    def `type`: Optional[zio.aws.ssmsap.model.ApplicationType]
    def arn: Optional[SsmSapArn]
    def appRegistryArn: Optional[AppRegistryArn]
    def status: Optional[zio.aws.ssmsap.model.ApplicationStatus]
    def components: Optional[List[ComponentId]]
    def lastUpdated: Optional[Timestamp]
    def statusMessage: Optional[String]
    def getId: ZIO[Any, AwsError, ApplicationId] =
      AwsError.unwrapOptionField("id", id)
    def getType: ZIO[Any, AwsError, zio.aws.ssmsap.model.ApplicationType] =
      AwsError.unwrapOptionField("type", `type`)
    def getArn: ZIO[Any, AwsError, SsmSapArn] =
      AwsError.unwrapOptionField("arn", arn)
    def getAppRegistryArn: ZIO[Any, AwsError, AppRegistryArn] =
      AwsError.unwrapOptionField("appRegistryArn", appRegistryArn)
    def getStatus: ZIO[Any, AwsError, zio.aws.ssmsap.model.ApplicationStatus] =
      AwsError.unwrapOptionField("status", status)
    def getComponents: ZIO[Any, AwsError, List[ComponentId]] =
      AwsError.unwrapOptionField("components", components)
    def getLastUpdated: ZIO[Any, AwsError, Timestamp] =
      AwsError.unwrapOptionField("lastUpdated", lastUpdated)
    def getStatusMessage: ZIO[Any, AwsError, String] =
      AwsError.unwrapOptionField("statusMessage", statusMessage)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.ssmsap.model.Application
  ) extends zio.aws.ssmsap.model.Application.ReadOnly {
    override val id: Optional[ApplicationId] = zio.aws.core.internal
      .optionalFromNullable(impl.id())
      .map(value => zio.aws.ssmsap.model.primitives.ApplicationId(value))
    override val `type`: Optional[zio.aws.ssmsap.model.ApplicationType] =
      zio.aws.core.internal
        .optionalFromNullable(impl.`type`())
        .map(value => zio.aws.ssmsap.model.ApplicationType.wrap(value))
    override val arn: Optional[SsmSapArn] = zio.aws.core.internal
      .optionalFromNullable(impl.arn())
      .map(value => zio.aws.ssmsap.model.primitives.SsmSapArn(value))
    override val appRegistryArn: Optional[AppRegistryArn] =
      zio.aws.core.internal
        .optionalFromNullable(impl.appRegistryArn())
        .map(value => zio.aws.ssmsap.model.primitives.AppRegistryArn(value))
    override val status: Optional[zio.aws.ssmsap.model.ApplicationStatus] =
      zio.aws.core.internal
        .optionalFromNullable(impl.status())
        .map(value => zio.aws.ssmsap.model.ApplicationStatus.wrap(value))
    override val components: Optional[List[ComponentId]] = zio.aws.core.internal
      .optionalFromNullable(impl.components())
      .map(value =>
        value.asScala.map { item =>
          zio.aws.ssmsap.model.primitives.ComponentId(item)
        }.toList
      )
    override val lastUpdated: Optional[Timestamp] = zio.aws.core.internal
      .optionalFromNullable(impl.lastUpdated())
      .map(value => zio.aws.ssmsap.model.primitives.Timestamp(value))
    override val statusMessage: Optional[String] = zio.aws.core.internal
      .optionalFromNullable(impl.statusMessage())
      .map(value => value: String)
  }
  def wrap(
      impl: software.amazon.awssdk.services.ssmsap.model.Application
  ): zio.aws.ssmsap.model.Application.ReadOnly = new Wrapper(impl)
}
