package zio.aws.ssmsap.model
import scala.jdk.CollectionConverters.*
sealed trait PermissionActionType {
  def unwrap: software.amazon.awssdk.services.ssmsap.model.PermissionActionType
}
object PermissionActionType {
  def wrap(
      value: software.amazon.awssdk.services.ssmsap.model.PermissionActionType
  ): zio.aws.ssmsap.model.PermissionActionType = value match {
    case software.amazon.awssdk.services.ssmsap.model.PermissionActionType.UNKNOWN_TO_SDK_VERSION =>
      val r = unknownToSdkVersion
      r
    case software.amazon.awssdk.services.ssmsap.model.PermissionActionType.RESTORE =>
      val r = RESTORE
      r
  }
  case object unknownToSdkVersion
      extends zio.aws.ssmsap.model.PermissionActionType {
    override def unwrap
        : software.amazon.awssdk.services.ssmsap.model.PermissionActionType =
      software.amazon.awssdk.services.ssmsap.model.PermissionActionType.UNKNOWN_TO_SDK_VERSION
  }
  case object RESTORE extends zio.aws.ssmsap.model.PermissionActionType {
    override def unwrap
        : software.amazon.awssdk.services.ssmsap.model.PermissionActionType =
      software.amazon.awssdk.services.ssmsap.model.PermissionActionType.RESTORE
  }
}
