package zio.aws.ssmsap.model
import zio.aws.ssmsap.model.primitives.Arn
import zio.ZIO
import zio.aws.core.{AwsError, BuilderHelper}
import zio.prelude.data.Optional
import scala.jdk.CollectionConverters.*
final case class GetResourcePermissionRequest(
    actionType: Optional[zio.aws.ssmsap.model.PermissionActionType] =
      Optional.Absent,
    resourceArn: Arn
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.ssmsap.model.GetResourcePermissionRequest = {
    import GetResourcePermissionRequest.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.ssmsap.model.GetResourcePermissionRequest
      .builder()
      .optionallyWith(actionType.map(value => value.unwrap))(_.actionType)
      .resourceArn(Arn.unwrap(resourceArn): java.lang.String)
      .build()
  }
  def asReadOnly: zio.aws.ssmsap.model.GetResourcePermissionRequest.ReadOnly =
    zio.aws.ssmsap.model.GetResourcePermissionRequest.wrap(buildAwsValue())
}
object GetResourcePermissionRequest {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.ssmsap.model.GetResourcePermissionRequest
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.ssmsap.model.GetResourcePermissionRequest =
      zio.aws.ssmsap.model.GetResourcePermissionRequest(
        actionType.map(value => value),
        resourceArn
      )
    def actionType: Optional[zio.aws.ssmsap.model.PermissionActionType]
    def resourceArn: Arn
    def getActionType
        : ZIO[Any, AwsError, zio.aws.ssmsap.model.PermissionActionType] =
      AwsError.unwrapOptionField("actionType", actionType)
    def getResourceArn: ZIO[Any, Nothing, Arn] = ZIO.succeed(resourceArn)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.ssmsap.model.GetResourcePermissionRequest
  ) extends zio.aws.ssmsap.model.GetResourcePermissionRequest.ReadOnly {
    override val actionType
        : Optional[zio.aws.ssmsap.model.PermissionActionType] =
      zio.aws.core.internal
        .optionalFromNullable(impl.actionType())
        .map(value => zio.aws.ssmsap.model.PermissionActionType.wrap(value))
    override val resourceArn: Arn =
      zio.aws.ssmsap.model.primitives.Arn(impl.resourceArn())
  }
  def wrap(
      impl: software.amazon.awssdk.services.ssmsap.model.GetResourcePermissionRequest
  ): zio.aws.ssmsap.model.GetResourcePermissionRequest.ReadOnly = new Wrapper(
    impl
  )
}
