package zio.aws.ssmsap.model
import scala.jdk.CollectionConverters.*
sealed trait DatabaseType {
  def unwrap: software.amazon.awssdk.services.ssmsap.model.DatabaseType
}
object DatabaseType {
  def wrap(
      value: software.amazon.awssdk.services.ssmsap.model.DatabaseType
  ): zio.aws.ssmsap.model.DatabaseType = value match {
    case software.amazon.awssdk.services.ssmsap.model.DatabaseType.UNKNOWN_TO_SDK_VERSION =>
      val r = unknownToSdkVersion
      r
    case software.amazon.awssdk.services.ssmsap.model.DatabaseType.SYSTEM =>
      val r = SYSTEM
      r
    case software.amazon.awssdk.services.ssmsap.model.DatabaseType.TENANT =>
      val r = TENANT
      r
  }
  case object unknownToSdkVersion extends zio.aws.ssmsap.model.DatabaseType {
    override def unwrap
        : software.amazon.awssdk.services.ssmsap.model.DatabaseType =
      software.amazon.awssdk.services.ssmsap.model.DatabaseType.UNKNOWN_TO_SDK_VERSION
  }
  case object SYSTEM extends zio.aws.ssmsap.model.DatabaseType {
    override def unwrap
        : software.amazon.awssdk.services.ssmsap.model.DatabaseType =
      software.amazon.awssdk.services.ssmsap.model.DatabaseType.SYSTEM
  }
  case object TENANT extends zio.aws.ssmsap.model.DatabaseType {
    override def unwrap
        : software.amazon.awssdk.services.ssmsap.model.DatabaseType =
      software.amazon.awssdk.services.ssmsap.model.DatabaseType.TENANT
  }
}
