package zio.aws.ssmsap.model
import zio.aws.ssmsap.model.primitives.{TagValue, TagKey}
import zio.ZIO
import zio.aws.core.{AwsError, BuilderHelper}
import zio.prelude.data.Optional
import scala.jdk.CollectionConverters.*
final case class GetApplicationResponse(
    application: Optional[zio.aws.ssmsap.model.Application] = Optional.Absent,
    tags: Optional[Map[TagKey, TagValue]] = Optional.Absent
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.ssmsap.model.GetApplicationResponse = {
    import GetApplicationResponse.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.ssmsap.model.GetApplicationResponse
      .builder()
      .optionallyWith(application.map(value => value.buildAwsValue()))(
        _.application
      )
      .optionallyWith(
        tags.map(value =>
          value
            .map({ case (key, value) =>
              (TagKey.unwrap(key): java.lang.String) -> (TagValue
                .unwrap(value): java.lang.String)
            })
            .asJava
        )
      )(_.tags)
      .build()
  }
  def asReadOnly: zio.aws.ssmsap.model.GetApplicationResponse.ReadOnly =
    zio.aws.ssmsap.model.GetApplicationResponse.wrap(buildAwsValue())
}
object GetApplicationResponse {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.ssmsap.model.GetApplicationResponse
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.ssmsap.model.GetApplicationResponse =
      zio.aws.ssmsap.model.GetApplicationResponse(
        application.map(value => value.asEditable),
        tags.map(value => value)
      )
    def application: Optional[zio.aws.ssmsap.model.Application.ReadOnly]
    def tags: Optional[Map[TagKey, TagValue]]
    def getApplication
        : ZIO[Any, AwsError, zio.aws.ssmsap.model.Application.ReadOnly] =
      AwsError.unwrapOptionField("application", application)
    def getTags: ZIO[Any, AwsError, Map[TagKey, TagValue]] =
      AwsError.unwrapOptionField("tags", tags)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.ssmsap.model.GetApplicationResponse
  ) extends zio.aws.ssmsap.model.GetApplicationResponse.ReadOnly {
    override val application
        : Optional[zio.aws.ssmsap.model.Application.ReadOnly] =
      zio.aws.core.internal
        .optionalFromNullable(impl.application())
        .map(value => zio.aws.ssmsap.model.Application.wrap(value))
    override val tags: Optional[Map[TagKey, TagValue]] = zio.aws.core.internal
      .optionalFromNullable(impl.tags())
      .map(value =>
        value.asScala
          .map({ case (key, value) =>
            zio.aws.ssmsap.model.primitives
              .TagKey(key) -> zio.aws.ssmsap.model.primitives.TagValue(value)
          })
          .toMap
      )
  }
  def wrap(
      impl: software.amazon.awssdk.services.ssmsap.model.GetApplicationResponse
  ): zio.aws.ssmsap.model.GetApplicationResponse.ReadOnly = new Wrapper(impl)
}
