package zio.aws.ssmsap.model
import zio.ZIO
import zio.aws.core.{AwsError, BuilderHelper}
import zio.prelude.data.Optional
import scala.jdk.CollectionConverters.*
final case class GetResourcePermissionResponse(
    policy: Optional[String] = Optional.Absent
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.ssmsap.model.GetResourcePermissionResponse = {
    import GetResourcePermissionResponse.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.ssmsap.model.GetResourcePermissionResponse
      .builder()
      .optionallyWith(policy.map(value => value: java.lang.String))(_.policy)
      .build()
  }
  def asReadOnly: zio.aws.ssmsap.model.GetResourcePermissionResponse.ReadOnly =
    zio.aws.ssmsap.model.GetResourcePermissionResponse.wrap(buildAwsValue())
}
object GetResourcePermissionResponse {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.ssmsap.model.GetResourcePermissionResponse
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.ssmsap.model.GetResourcePermissionResponse =
      zio.aws.ssmsap.model
        .GetResourcePermissionResponse(policy.map(value => value))
    def policy: Optional[String]
    def getPolicy: ZIO[Any, AwsError, String] =
      AwsError.unwrapOptionField("policy", policy)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.ssmsap.model.GetResourcePermissionResponse
  ) extends zio.aws.ssmsap.model.GetResourcePermissionResponse.ReadOnly {
    override val policy: Optional[String] = zio.aws.core.internal
      .optionalFromNullable(impl.policy())
      .map(value => value: String)
  }
  def wrap(
      impl: software.amazon.awssdk.services.ssmsap.model.GetResourcePermissionResponse
  ): zio.aws.ssmsap.model.GetResourcePermissionResponse.ReadOnly = new Wrapper(
    impl
  )
}
