package zio.aws.ssmsap.model
import zio.aws.ssmsap.model.primitives.{
  DatabaseId,
  SsmSapArn,
  TagValue,
  ComponentId,
  ApplicationId,
  TagKey
}
import zio.ZIO
import zio.aws.core.{AwsError, BuilderHelper}
import zio.prelude.data.Optional
import scala.jdk.CollectionConverters.*
final case class DatabaseSummary(
    applicationId: Optional[ApplicationId] = Optional.Absent,
    componentId: Optional[ComponentId] = Optional.Absent,
    databaseId: Optional[DatabaseId] = Optional.Absent,
    databaseType: Optional[zio.aws.ssmsap.model.DatabaseType] = Optional.Absent,
    arn: Optional[SsmSapArn] = Optional.Absent,
    tags: Optional[Map[TagKey, TagValue]] = Optional.Absent
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.ssmsap.model.DatabaseSummary = {
    import DatabaseSummary.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.ssmsap.model.DatabaseSummary
      .builder()
      .optionallyWith(
        applicationId.map(value =>
          ApplicationId.unwrap(value): java.lang.String
        )
      )(_.applicationId)
      .optionallyWith(
        componentId.map(value => ComponentId.unwrap(value): java.lang.String)
      )(_.componentId)
      .optionallyWith(
        databaseId.map(value => DatabaseId.unwrap(value): java.lang.String)
      )(_.databaseId)
      .optionallyWith(databaseType.map(value => value.unwrap))(_.databaseType)
      .optionallyWith(
        arn.map(value => SsmSapArn.unwrap(value): java.lang.String)
      )(_.arn)
      .optionallyWith(
        tags.map(value =>
          value
            .map({ case (key, value) =>
              (TagKey.unwrap(key): java.lang.String) -> (TagValue
                .unwrap(value): java.lang.String)
            })
            .asJava
        )
      )(_.tags)
      .build()
  }
  def asReadOnly: zio.aws.ssmsap.model.DatabaseSummary.ReadOnly =
    zio.aws.ssmsap.model.DatabaseSummary.wrap(buildAwsValue())
}
object DatabaseSummary {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.ssmsap.model.DatabaseSummary
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.ssmsap.model.DatabaseSummary =
      zio.aws.ssmsap.model.DatabaseSummary(
        applicationId.map(value => value),
        componentId.map(value => value),
        databaseId.map(value => value),
        databaseType.map(value => value),
        arn.map(value => value),
        tags.map(value => value)
      )
    def applicationId: Optional[ApplicationId]
    def componentId: Optional[ComponentId]
    def databaseId: Optional[DatabaseId]
    def databaseType: Optional[zio.aws.ssmsap.model.DatabaseType]
    def arn: Optional[SsmSapArn]
    def tags: Optional[Map[TagKey, TagValue]]
    def getApplicationId: ZIO[Any, AwsError, ApplicationId] =
      AwsError.unwrapOptionField("applicationId", applicationId)
    def getComponentId: ZIO[Any, AwsError, ComponentId] =
      AwsError.unwrapOptionField("componentId", componentId)
    def getDatabaseId: ZIO[Any, AwsError, DatabaseId] =
      AwsError.unwrapOptionField("databaseId", databaseId)
    def getDatabaseType: ZIO[Any, AwsError, zio.aws.ssmsap.model.DatabaseType] =
      AwsError.unwrapOptionField("databaseType", databaseType)
    def getArn: ZIO[Any, AwsError, SsmSapArn] =
      AwsError.unwrapOptionField("arn", arn)
    def getTags: ZIO[Any, AwsError, Map[TagKey, TagValue]] =
      AwsError.unwrapOptionField("tags", tags)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.ssmsap.model.DatabaseSummary
  ) extends zio.aws.ssmsap.model.DatabaseSummary.ReadOnly {
    override val applicationId: Optional[ApplicationId] = zio.aws.core.internal
      .optionalFromNullable(impl.applicationId())
      .map(value => zio.aws.ssmsap.model.primitives.ApplicationId(value))
    override val componentId: Optional[ComponentId] = zio.aws.core.internal
      .optionalFromNullable(impl.componentId())
      .map(value => zio.aws.ssmsap.model.primitives.ComponentId(value))
    override val databaseId: Optional[DatabaseId] = zio.aws.core.internal
      .optionalFromNullable(impl.databaseId())
      .map(value => zio.aws.ssmsap.model.primitives.DatabaseId(value))
    override val databaseType: Optional[zio.aws.ssmsap.model.DatabaseType] =
      zio.aws.core.internal
        .optionalFromNullable(impl.databaseType())
        .map(value => zio.aws.ssmsap.model.DatabaseType.wrap(value))
    override val arn: Optional[SsmSapArn] = zio.aws.core.internal
      .optionalFromNullable(impl.arn())
      .map(value => zio.aws.ssmsap.model.primitives.SsmSapArn(value))
    override val tags: Optional[Map[TagKey, TagValue]] = zio.aws.core.internal
      .optionalFromNullable(impl.tags())
      .map(value =>
        value.asScala
          .map({ case (key, value) =>
            zio.aws.ssmsap.model.primitives
              .TagKey(key) -> zio.aws.ssmsap.model.primitives.TagValue(value)
          })
          .toMap
      )
  }
  def wrap(
      impl: software.amazon.awssdk.services.ssmsap.model.DatabaseSummary
  ): zio.aws.ssmsap.model.DatabaseSummary.ReadOnly = new Wrapper(impl)
}
