package zio.aws.ssmsap.model
import scala.jdk.CollectionConverters.*
sealed trait ApplicationStatus {
  def unwrap: software.amazon.awssdk.services.ssmsap.model.ApplicationStatus
}
object ApplicationStatus {
  def wrap(
      value: software.amazon.awssdk.services.ssmsap.model.ApplicationStatus
  ): zio.aws.ssmsap.model.ApplicationStatus = value match {
    case software.amazon.awssdk.services.ssmsap.model.ApplicationStatus.UNKNOWN_TO_SDK_VERSION =>
      val r = unknownToSdkVersion
      r
    case software.amazon.awssdk.services.ssmsap.model.ApplicationStatus.ACTIVATED =>
      val r = ACTIVATED
      r
    case software.amazon.awssdk.services.ssmsap.model.ApplicationStatus.STARTING =>
      val r = STARTING
      r
    case software.amazon.awssdk.services.ssmsap.model.ApplicationStatus.STOPPED =>
      val r = STOPPED
      r
    case software.amazon.awssdk.services.ssmsap.model.ApplicationStatus.STOPPING =>
      val r = STOPPING
      r
    case software.amazon.awssdk.services.ssmsap.model.ApplicationStatus.FAILED =>
      val r = FAILED
      r
    case software.amazon.awssdk.services.ssmsap.model.ApplicationStatus.REGISTERING =>
      val r = REGISTERING
      r
    case software.amazon.awssdk.services.ssmsap.model.ApplicationStatus.DELETING =>
      val r = DELETING
      r
    case software.amazon.awssdk.services.ssmsap.model.ApplicationStatus.UNKNOWN =>
      val r = UNKNOWN
      r
  }
  case object unknownToSdkVersion
      extends zio.aws.ssmsap.model.ApplicationStatus {
    override def unwrap
        : software.amazon.awssdk.services.ssmsap.model.ApplicationStatus =
      software.amazon.awssdk.services.ssmsap.model.ApplicationStatus.UNKNOWN_TO_SDK_VERSION
  }
  case object ACTIVATED extends zio.aws.ssmsap.model.ApplicationStatus {
    override def unwrap
        : software.amazon.awssdk.services.ssmsap.model.ApplicationStatus =
      software.amazon.awssdk.services.ssmsap.model.ApplicationStatus.ACTIVATED
  }
  case object STARTING extends zio.aws.ssmsap.model.ApplicationStatus {
    override def unwrap
        : software.amazon.awssdk.services.ssmsap.model.ApplicationStatus =
      software.amazon.awssdk.services.ssmsap.model.ApplicationStatus.STARTING
  }
  case object STOPPED extends zio.aws.ssmsap.model.ApplicationStatus {
    override def unwrap
        : software.amazon.awssdk.services.ssmsap.model.ApplicationStatus =
      software.amazon.awssdk.services.ssmsap.model.ApplicationStatus.STOPPED
  }
  case object STOPPING extends zio.aws.ssmsap.model.ApplicationStatus {
    override def unwrap
        : software.amazon.awssdk.services.ssmsap.model.ApplicationStatus =
      software.amazon.awssdk.services.ssmsap.model.ApplicationStatus.STOPPING
  }
  case object FAILED extends zio.aws.ssmsap.model.ApplicationStatus {
    override def unwrap
        : software.amazon.awssdk.services.ssmsap.model.ApplicationStatus =
      software.amazon.awssdk.services.ssmsap.model.ApplicationStatus.FAILED
  }
  case object REGISTERING extends zio.aws.ssmsap.model.ApplicationStatus {
    override def unwrap
        : software.amazon.awssdk.services.ssmsap.model.ApplicationStatus =
      software.amazon.awssdk.services.ssmsap.model.ApplicationStatus.REGISTERING
  }
  case object DELETING extends zio.aws.ssmsap.model.ApplicationStatus {
    override def unwrap
        : software.amazon.awssdk.services.ssmsap.model.ApplicationStatus =
      software.amazon.awssdk.services.ssmsap.model.ApplicationStatus.DELETING
  }
  case object UNKNOWN extends zio.aws.ssmsap.model.ApplicationStatus {
    override def unwrap
        : software.amazon.awssdk.services.ssmsap.model.ApplicationStatus =
      software.amazon.awssdk.services.ssmsap.model.ApplicationStatus.UNKNOWN
  }
}
