package zio.aws.ssmsap.model
import zio.ZIO
import zio.aws.core.{AwsError, BuilderHelper}
import zio.prelude.data.Optional
import scala.jdk.CollectionConverters.*
final case class GetOperationResponse(
    operation: Optional[zio.aws.ssmsap.model.Operation] = Optional.Absent
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.ssmsap.model.GetOperationResponse = {
    import GetOperationResponse.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.ssmsap.model.GetOperationResponse
      .builder()
      .optionallyWith(operation.map(value => value.buildAwsValue()))(
        _.operation
      )
      .build()
  }
  def asReadOnly: zio.aws.ssmsap.model.GetOperationResponse.ReadOnly =
    zio.aws.ssmsap.model.GetOperationResponse.wrap(buildAwsValue())
}
object GetOperationResponse {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.ssmsap.model.GetOperationResponse
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.ssmsap.model.GetOperationResponse =
      zio.aws.ssmsap.model
        .GetOperationResponse(operation.map(value => value.asEditable))
    def operation: Optional[zio.aws.ssmsap.model.Operation.ReadOnly]
    def getOperation
        : ZIO[Any, AwsError, zio.aws.ssmsap.model.Operation.ReadOnly] =
      AwsError.unwrapOptionField("operation", operation)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.ssmsap.model.GetOperationResponse
  ) extends zio.aws.ssmsap.model.GetOperationResponse.ReadOnly {
    override val operation: Optional[zio.aws.ssmsap.model.Operation.ReadOnly] =
      zio.aws.core.internal
        .optionalFromNullable(impl.operation())
        .map(value => zio.aws.ssmsap.model.Operation.wrap(value))
  }
  def wrap(
      impl: software.amazon.awssdk.services.ssmsap.model.GetOperationResponse
  ): zio.aws.ssmsap.model.GetOperationResponse.ReadOnly = new Wrapper(impl)
}
