package zio.aws.ssmsap.model
import zio.aws.ssmsap.model.primitives.{
  TagValue,
  TagKey,
  ComponentId,
  ApplicationId
}
import zio.ZIO
import zio.aws.core.{AwsError, BuilderHelper}
import zio.prelude.data.Optional
import scala.jdk.CollectionConverters.*
final case class ComponentSummary(
    applicationId: Optional[ApplicationId] = Optional.Absent,
    componentId: Optional[ComponentId] = Optional.Absent,
    componentType: Optional[zio.aws.ssmsap.model.ComponentType] =
      Optional.Absent,
    tags: Optional[Map[TagKey, TagValue]] = Optional.Absent
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.ssmsap.model.ComponentSummary = {
    import ComponentSummary.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.ssmsap.model.ComponentSummary
      .builder()
      .optionallyWith(
        applicationId.map(value =>
          ApplicationId.unwrap(value): java.lang.String
        )
      )(_.applicationId)
      .optionallyWith(
        componentId.map(value => ComponentId.unwrap(value): java.lang.String)
      )(_.componentId)
      .optionallyWith(componentType.map(value => value.unwrap))(_.componentType)
      .optionallyWith(
        tags.map(value =>
          value
            .map({ case (key, value) =>
              (TagKey.unwrap(key): java.lang.String) -> (TagValue
                .unwrap(value): java.lang.String)
            })
            .asJava
        )
      )(_.tags)
      .build()
  }
  def asReadOnly: zio.aws.ssmsap.model.ComponentSummary.ReadOnly =
    zio.aws.ssmsap.model.ComponentSummary.wrap(buildAwsValue())
}
object ComponentSummary {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.ssmsap.model.ComponentSummary
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.ssmsap.model.ComponentSummary =
      zio.aws.ssmsap.model.ComponentSummary(
        applicationId.map(value => value),
        componentId.map(value => value),
        componentType.map(value => value),
        tags.map(value => value)
      )
    def applicationId: Optional[ApplicationId]
    def componentId: Optional[ComponentId]
    def componentType: Optional[zio.aws.ssmsap.model.ComponentType]
    def tags: Optional[Map[TagKey, TagValue]]
    def getApplicationId: ZIO[Any, AwsError, ApplicationId] =
      AwsError.unwrapOptionField("applicationId", applicationId)
    def getComponentId: ZIO[Any, AwsError, ComponentId] =
      AwsError.unwrapOptionField("componentId", componentId)
    def getComponentType
        : ZIO[Any, AwsError, zio.aws.ssmsap.model.ComponentType] =
      AwsError.unwrapOptionField("componentType", componentType)
    def getTags: ZIO[Any, AwsError, Map[TagKey, TagValue]] =
      AwsError.unwrapOptionField("tags", tags)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.ssmsap.model.ComponentSummary
  ) extends zio.aws.ssmsap.model.ComponentSummary.ReadOnly {
    override val applicationId: Optional[ApplicationId] = zio.aws.core.internal
      .optionalFromNullable(impl.applicationId())
      .map(value => zio.aws.ssmsap.model.primitives.ApplicationId(value))
    override val componentId: Optional[ComponentId] = zio.aws.core.internal
      .optionalFromNullable(impl.componentId())
      .map(value => zio.aws.ssmsap.model.primitives.ComponentId(value))
    override val componentType: Optional[zio.aws.ssmsap.model.ComponentType] =
      zio.aws.core.internal
        .optionalFromNullable(impl.componentType())
        .map(value => zio.aws.ssmsap.model.ComponentType.wrap(value))
    override val tags: Optional[Map[TagKey, TagValue]] = zio.aws.core.internal
      .optionalFromNullable(impl.tags())
      .map(value =>
        value.asScala
          .map({ case (key, value) =>
            zio.aws.ssmsap.model.primitives
              .TagKey(key) -> zio.aws.ssmsap.model.primitives.TagValue(value)
          })
          .toMap
      )
  }
  def wrap(
      impl: software.amazon.awssdk.services.ssmsap.model.ComponentSummary
  ): zio.aws.ssmsap.model.ComponentSummary.ReadOnly = new Wrapper(impl)
}
