package zio.aws.ssmsap.model
import scala.jdk.CollectionConverters._
sealed trait AllocationType {
  def unwrap: software.amazon.awssdk.services.ssmsap.model.AllocationType
}
object AllocationType {
  def wrap(
      value: software.amazon.awssdk.services.ssmsap.model.AllocationType
  ): zio.aws.ssmsap.model.AllocationType = value match {
    case software.amazon.awssdk.services.ssmsap.model.AllocationType.UNKNOWN_TO_SDK_VERSION =>
      val r = unknownToSdkVersion
      r
    case software.amazon.awssdk.services.ssmsap.model.AllocationType.VPC_SUBNET =>
      val r = VPC_SUBNET
      r
    case software.amazon.awssdk.services.ssmsap.model.AllocationType.ELASTIC_IP =>
      val r = ELASTIC_IP
      r
    case software.amazon.awssdk.services.ssmsap.model.AllocationType.OVERLAY =>
      val r = OVERLAY
      r
    case software.amazon.awssdk.services.ssmsap.model.AllocationType.UNKNOWN =>
      val r = UNKNOWN
      r
  }
  case object unknownToSdkVersion extends zio.aws.ssmsap.model.AllocationType {
    override def unwrap
        : software.amazon.awssdk.services.ssmsap.model.AllocationType =
      software.amazon.awssdk.services.ssmsap.model.AllocationType.UNKNOWN_TO_SDK_VERSION
  }
  case object VPC_SUBNET extends zio.aws.ssmsap.model.AllocationType {
    override def unwrap
        : software.amazon.awssdk.services.ssmsap.model.AllocationType =
      software.amazon.awssdk.services.ssmsap.model.AllocationType.VPC_SUBNET
  }
  case object ELASTIC_IP extends zio.aws.ssmsap.model.AllocationType {
    override def unwrap
        : software.amazon.awssdk.services.ssmsap.model.AllocationType =
      software.amazon.awssdk.services.ssmsap.model.AllocationType.ELASTIC_IP
  }
  case object OVERLAY extends zio.aws.ssmsap.model.AllocationType {
    override def unwrap
        : software.amazon.awssdk.services.ssmsap.model.AllocationType =
      software.amazon.awssdk.services.ssmsap.model.AllocationType.OVERLAY
  }
  case object UNKNOWN extends zio.aws.ssmsap.model.AllocationType {
    override def unwrap
        : software.amazon.awssdk.services.ssmsap.model.AllocationType =
      software.amazon.awssdk.services.ssmsap.model.AllocationType.UNKNOWN
  }
}
