package zio.aws.ssmsap.model
import zio.aws.ssmsap.model.primitives.OperationId
import zio.ZIO
import zio.aws.core.{AwsError, BuilderHelper}
import zio.prelude.data.Optional
import scala.jdk.CollectionConverters._
final case class StartApplicationRefreshResponse(
    operationId: Optional[OperationId] = Optional.Absent
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.ssmsap.model.StartApplicationRefreshResponse = {
    import StartApplicationRefreshResponse.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.ssmsap.model.StartApplicationRefreshResponse
      .builder()
      .optionallyWith(
        operationId.map(value => OperationId.unwrap(value): java.lang.String)
      )(_.operationId)
      .build()
  }
  def asReadOnly
      : zio.aws.ssmsap.model.StartApplicationRefreshResponse.ReadOnly =
    zio.aws.ssmsap.model.StartApplicationRefreshResponse.wrap(buildAwsValue())
}
object StartApplicationRefreshResponse {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.ssmsap.model.StartApplicationRefreshResponse
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.ssmsap.model.StartApplicationRefreshResponse =
      zio.aws.ssmsap.model
        .StartApplicationRefreshResponse(operationId.map(value => value))
    def operationId: Optional[OperationId]
    def getOperationId: ZIO[Any, AwsError, OperationId] =
      AwsError.unwrapOptionField("operationId", operationId)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.ssmsap.model.StartApplicationRefreshResponse
  ) extends zio.aws.ssmsap.model.StartApplicationRefreshResponse.ReadOnly {
    override val operationId: Optional[OperationId] = zio.aws.core.internal
      .optionalFromNullable(impl.operationId())
      .map(value => zio.aws.ssmsap.model.primitives.OperationId(value))
  }
  def wrap(
      impl: software.amazon.awssdk.services.ssmsap.model.StartApplicationRefreshResponse
  ): zio.aws.ssmsap.model.StartApplicationRefreshResponse.ReadOnly =
    new Wrapper(impl)
}
