package zio.aws.ssmsap.model
import zio.aws.ssmsap.model.primitives.NextToken
import zio.ZIO
import zio.aws.core.{AwsError, BuilderHelper}
import zio.prelude.data.Optional
import scala.jdk.CollectionConverters._
final case class ListDatabasesResponse(
    databases: Optional[Iterable[zio.aws.ssmsap.model.DatabaseSummary]] =
      Optional.Absent,
    nextToken: Optional[NextToken] = Optional.Absent
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.ssmsap.model.ListDatabasesResponse = {
    import ListDatabasesResponse.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.ssmsap.model.ListDatabasesResponse
      .builder()
      .optionallyWith(
        databases.map(value =>
          value.map { item =>
            item.buildAwsValue()
          }.asJavaCollection
        )
      )(_.databases)
      .optionallyWith(
        nextToken.map(value => NextToken.unwrap(value): java.lang.String)
      )(_.nextToken)
      .build()
  }
  def asReadOnly: zio.aws.ssmsap.model.ListDatabasesResponse.ReadOnly =
    zio.aws.ssmsap.model.ListDatabasesResponse.wrap(buildAwsValue())
}
object ListDatabasesResponse {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.ssmsap.model.ListDatabasesResponse
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.ssmsap.model.ListDatabasesResponse =
      zio.aws.ssmsap.model.ListDatabasesResponse(
        databases.map(value =>
          value.map { item =>
            item.asEditable
          }
        ),
        nextToken.map(value => value)
      )
    def databases: Optional[List[zio.aws.ssmsap.model.DatabaseSummary.ReadOnly]]
    def nextToken: Optional[NextToken]
    def getDatabases: ZIO[Any, AwsError, List[
      zio.aws.ssmsap.model.DatabaseSummary.ReadOnly
    ]] = AwsError.unwrapOptionField("databases", databases)
    def getNextToken: ZIO[Any, AwsError, NextToken] =
      AwsError.unwrapOptionField("nextToken", nextToken)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.ssmsap.model.ListDatabasesResponse
  ) extends zio.aws.ssmsap.model.ListDatabasesResponse.ReadOnly {
    override val databases
        : Optional[List[zio.aws.ssmsap.model.DatabaseSummary.ReadOnly]] =
      zio.aws.core.internal
        .optionalFromNullable(impl.databases())
        .map(value =>
          value.asScala.map { item =>
            zio.aws.ssmsap.model.DatabaseSummary.wrap(item)
          }.toList
        )
    override val nextToken: Optional[NextToken] = zio.aws.core.internal
      .optionalFromNullable(impl.nextToken())
      .map(value => zio.aws.ssmsap.model.primitives.NextToken(value))
  }
  def wrap(
      impl: software.amazon.awssdk.services.ssmsap.model.ListDatabasesResponse
  ): zio.aws.ssmsap.model.ListDatabasesResponse.ReadOnly = new Wrapper(impl)
}
