package zio.aws.ssmsap.model
import zio.aws.ssmsap.model.primitives.OperationId
import zio.ZIO
import zio.aws.core.{AwsError, BuilderHelper}
import zio.prelude.data.Optional
import scala.jdk.CollectionConverters._
final case class UpdateApplicationSettingsResponse(
    message: Optional[String] = Optional.Absent,
    operationIds: Optional[Iterable[OperationId]] = Optional.Absent
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.ssmsap.model.UpdateApplicationSettingsResponse = {
    import UpdateApplicationSettingsResponse.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.ssmsap.model.UpdateApplicationSettingsResponse
      .builder()
      .optionallyWith(message.map(value => value: java.lang.String))(_.message)
      .optionallyWith(
        operationIds.map(value =>
          value.map { item =>
            OperationId.unwrap(item): java.lang.String
          }.asJavaCollection
        )
      )(_.operationIds)
      .build()
  }
  def asReadOnly
      : zio.aws.ssmsap.model.UpdateApplicationSettingsResponse.ReadOnly =
    zio.aws.ssmsap.model.UpdateApplicationSettingsResponse.wrap(buildAwsValue())
}
object UpdateApplicationSettingsResponse {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.ssmsap.model.UpdateApplicationSettingsResponse
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.ssmsap.model.UpdateApplicationSettingsResponse =
      zio.aws.ssmsap.model.UpdateApplicationSettingsResponse(
        message.map(value => value),
        operationIds.map(value => value)
      )
    def message: Optional[String]
    def operationIds: Optional[List[OperationId]]
    def getMessage: ZIO[Any, AwsError, String] =
      AwsError.unwrapOptionField("message", message)
    def getOperationIds: ZIO[Any, AwsError, List[OperationId]] =
      AwsError.unwrapOptionField("operationIds", operationIds)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.ssmsap.model.UpdateApplicationSettingsResponse
  ) extends zio.aws.ssmsap.model.UpdateApplicationSettingsResponse.ReadOnly {
    override val message: Optional[String] = zio.aws.core.internal
      .optionalFromNullable(impl.message())
      .map(value => value: String)
    override val operationIds: Optional[List[OperationId]] =
      zio.aws.core.internal
        .optionalFromNullable(impl.operationIds())
        .map(value =>
          value.asScala.map { item =>
            zio.aws.ssmsap.model.primitives.OperationId(item)
          }.toList
        )
  }
  def wrap(
      impl: software.amazon.awssdk.services.ssmsap.model.UpdateApplicationSettingsResponse
  ): zio.aws.ssmsap.model.UpdateApplicationSettingsResponse.ReadOnly =
    new Wrapper(impl)
}
