package zio.aws.ssmsap.model
import scala.jdk.CollectionConverters._
sealed trait ComponentType {
  def unwrap: software.amazon.awssdk.services.ssmsap.model.ComponentType
}
object ComponentType {
  def wrap(
      value: software.amazon.awssdk.services.ssmsap.model.ComponentType
  ): zio.aws.ssmsap.model.ComponentType = value match {
    case software.amazon.awssdk.services.ssmsap.model.ComponentType.UNKNOWN_TO_SDK_VERSION =>
      val r = unknownToSdkVersion
      r
    case software.amazon.awssdk.services.ssmsap.model.ComponentType.HANA =>
      val r = HANA
      r
    case software.amazon.awssdk.services.ssmsap.model.ComponentType.HANA_NODE =>
      val r = HANA_NODE
      r
  }
  case object unknownToSdkVersion extends zio.aws.ssmsap.model.ComponentType {
    override def unwrap
        : software.amazon.awssdk.services.ssmsap.model.ComponentType =
      software.amazon.awssdk.services.ssmsap.model.ComponentType.UNKNOWN_TO_SDK_VERSION
  }
  case object HANA extends zio.aws.ssmsap.model.ComponentType {
    override def unwrap
        : software.amazon.awssdk.services.ssmsap.model.ComponentType =
      software.amazon.awssdk.services.ssmsap.model.ComponentType.HANA
  }
  case object HANA_NODE extends zio.aws.ssmsap.model.ComponentType {
    override def unwrap
        : software.amazon.awssdk.services.ssmsap.model.ComponentType =
      software.amazon.awssdk.services.ssmsap.model.ComponentType.HANA_NODE
  }
}
