package zio.aws.ssmsap.model
import zio.aws.ssmsap.model.primitives.{
  TagValue,
  TagKey,
  SsmSapArn,
  ApplicationId
}
import zio.ZIO
import zio.aws.core.{AwsError, BuilderHelper}
import zio.prelude.data.Optional
import scala.jdk.CollectionConverters._
final case class ApplicationSummary(
    id: Optional[ApplicationId] = Optional.Absent,
    `type`: Optional[zio.aws.ssmsap.model.ApplicationType] = Optional.Absent,
    arn: Optional[SsmSapArn] = Optional.Absent,
    tags: Optional[Map[TagKey, TagValue]] = Optional.Absent
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.ssmsap.model.ApplicationSummary = {
    import ApplicationSummary.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.ssmsap.model.ApplicationSummary
      .builder()
      .optionallyWith(
        id.map(value => ApplicationId.unwrap(value): java.lang.String)
      )(_.id)
      .optionallyWith(`type`.map(value => value.unwrap))(_.`type`)
      .optionallyWith(
        arn.map(value => SsmSapArn.unwrap(value): java.lang.String)
      )(_.arn)
      .optionallyWith(
        tags.map(value =>
          value
            .map({ case (key, value) =>
              (TagKey.unwrap(key): java.lang.String) -> (TagValue
                .unwrap(value): java.lang.String)
            })
            .asJava
        )
      )(_.tags)
      .build()
  }
  def asReadOnly: zio.aws.ssmsap.model.ApplicationSummary.ReadOnly =
    zio.aws.ssmsap.model.ApplicationSummary.wrap(buildAwsValue())
}
object ApplicationSummary {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.ssmsap.model.ApplicationSummary
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.ssmsap.model.ApplicationSummary =
      zio.aws.ssmsap.model.ApplicationSummary(
        id.map(value => value),
        `type`.map(value => value),
        arn.map(value => value),
        tags.map(value => value)
      )
    def id: Optional[ApplicationId]
    def `type`: Optional[zio.aws.ssmsap.model.ApplicationType]
    def arn: Optional[SsmSapArn]
    def tags: Optional[Map[TagKey, TagValue]]
    def getId: ZIO[Any, AwsError, ApplicationId] =
      AwsError.unwrapOptionField("id", id)
    def getType: ZIO[Any, AwsError, zio.aws.ssmsap.model.ApplicationType] =
      AwsError.unwrapOptionField("type", `type`)
    def getArn: ZIO[Any, AwsError, SsmSapArn] =
      AwsError.unwrapOptionField("arn", arn)
    def getTags: ZIO[Any, AwsError, Map[TagKey, TagValue]] =
      AwsError.unwrapOptionField("tags", tags)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.ssmsap.model.ApplicationSummary
  ) extends zio.aws.ssmsap.model.ApplicationSummary.ReadOnly {
    override val id: Optional[ApplicationId] = zio.aws.core.internal
      .optionalFromNullable(impl.id())
      .map(value => zio.aws.ssmsap.model.primitives.ApplicationId(value))
    override val `type`: Optional[zio.aws.ssmsap.model.ApplicationType] =
      zio.aws.core.internal
        .optionalFromNullable(impl.`type`())
        .map(value => zio.aws.ssmsap.model.ApplicationType.wrap(value))
    override val arn: Optional[SsmSapArn] = zio.aws.core.internal
      .optionalFromNullable(impl.arn())
      .map(value => zio.aws.ssmsap.model.primitives.SsmSapArn(value))
    override val tags: Optional[Map[TagKey, TagValue]] = zio.aws.core.internal
      .optionalFromNullable(impl.tags())
      .map(value =>
        value.asScala
          .map({ case (key, value) =>
            zio.aws.ssmsap.model.primitives
              .TagKey(key) -> zio.aws.ssmsap.model.primitives.TagValue(value)
          })
          .toMap
      )
  }
  def wrap(
      impl: software.amazon.awssdk.services.ssmsap.model.ApplicationSummary
  ): zio.aws.ssmsap.model.ApplicationSummary.ReadOnly = new Wrapper(impl)
}
