package zio.aws.ssmsap.model
import scala.jdk.CollectionConverters._
sealed trait ReplicationMode {
  def unwrap: software.amazon.awssdk.services.ssmsap.model.ReplicationMode
}
object ReplicationMode {
  def wrap(
      value: software.amazon.awssdk.services.ssmsap.model.ReplicationMode
  ): zio.aws.ssmsap.model.ReplicationMode = value match {
    case software.amazon.awssdk.services.ssmsap.model.ReplicationMode.UNKNOWN_TO_SDK_VERSION =>
      val r = unknownToSdkVersion
      r
    case software.amazon.awssdk.services.ssmsap.model.ReplicationMode.PRIMARY =>
      val r = PRIMARY
      r
    case software.amazon.awssdk.services.ssmsap.model.ReplicationMode.NONE =>
      val r = NONE
      r
    case software.amazon.awssdk.services.ssmsap.model.ReplicationMode.SYNC =>
      val r = SYNC
      r
    case software.amazon.awssdk.services.ssmsap.model.ReplicationMode.SYNCMEM =>
      val r = SYNCMEM
      r
    case software.amazon.awssdk.services.ssmsap.model.ReplicationMode.ASYNC =>
      val r = ASYNC
      r
  }
  case object unknownToSdkVersion extends zio.aws.ssmsap.model.ReplicationMode {
    override def unwrap
        : software.amazon.awssdk.services.ssmsap.model.ReplicationMode =
      software.amazon.awssdk.services.ssmsap.model.ReplicationMode.UNKNOWN_TO_SDK_VERSION
  }
  case object PRIMARY extends zio.aws.ssmsap.model.ReplicationMode {
    override def unwrap
        : software.amazon.awssdk.services.ssmsap.model.ReplicationMode =
      software.amazon.awssdk.services.ssmsap.model.ReplicationMode.PRIMARY
  }
  case object NONE extends zio.aws.ssmsap.model.ReplicationMode {
    override def unwrap
        : software.amazon.awssdk.services.ssmsap.model.ReplicationMode =
      software.amazon.awssdk.services.ssmsap.model.ReplicationMode.NONE
  }
  case object SYNC extends zio.aws.ssmsap.model.ReplicationMode {
    override def unwrap
        : software.amazon.awssdk.services.ssmsap.model.ReplicationMode =
      software.amazon.awssdk.services.ssmsap.model.ReplicationMode.SYNC
  }
  case object SYNCMEM extends zio.aws.ssmsap.model.ReplicationMode {
    override def unwrap
        : software.amazon.awssdk.services.ssmsap.model.ReplicationMode =
      software.amazon.awssdk.services.ssmsap.model.ReplicationMode.SYNCMEM
  }
  case object ASYNC extends zio.aws.ssmsap.model.ReplicationMode {
    override def unwrap
        : software.amazon.awssdk.services.ssmsap.model.ReplicationMode =
      software.amazon.awssdk.services.ssmsap.model.ReplicationMode.ASYNC
  }
}
