package zio.aws.ssmsap.model
import zio.ZIO
import zio.aws.core.{AwsError, BuilderHelper}
import zio.prelude.data.Optional
import scala.jdk.CollectionConverters._
final case class AssociatedHost(
    hostname: Optional[String] = Optional.Absent,
    ec2InstanceId: Optional[String] = Optional.Absent,
    osVersion: Optional[String] = Optional.Absent
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.ssmsap.model.AssociatedHost = {
    import AssociatedHost.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.ssmsap.model.AssociatedHost
      .builder()
      .optionallyWith(hostname.map(value => value: java.lang.String))(
        _.hostname
      )
      .optionallyWith(ec2InstanceId.map(value => value: java.lang.String))(
        _.ec2InstanceId
      )
      .optionallyWith(osVersion.map(value => value: java.lang.String))(
        _.osVersion
      )
      .build()
  }
  def asReadOnly: zio.aws.ssmsap.model.AssociatedHost.ReadOnly =
    zio.aws.ssmsap.model.AssociatedHost.wrap(buildAwsValue())
}
object AssociatedHost {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.ssmsap.model.AssociatedHost
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.ssmsap.model.AssociatedHost =
      zio.aws.ssmsap.model.AssociatedHost(
        hostname.map(value => value),
        ec2InstanceId.map(value => value),
        osVersion.map(value => value)
      )
    def hostname: Optional[String]
    def ec2InstanceId: Optional[String]
    def osVersion: Optional[String]
    def getHostname: ZIO[Any, AwsError, String] =
      AwsError.unwrapOptionField("hostname", hostname)
    def getEc2InstanceId: ZIO[Any, AwsError, String] =
      AwsError.unwrapOptionField("ec2InstanceId", ec2InstanceId)
    def getOsVersion: ZIO[Any, AwsError, String] =
      AwsError.unwrapOptionField("osVersion", osVersion)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.ssmsap.model.AssociatedHost
  ) extends zio.aws.ssmsap.model.AssociatedHost.ReadOnly {
    override val hostname: Optional[String] = zio.aws.core.internal
      .optionalFromNullable(impl.hostname())
      .map(value => value: String)
    override val ec2InstanceId: Optional[String] = zio.aws.core.internal
      .optionalFromNullable(impl.ec2InstanceId())
      .map(value => value: String)
    override val osVersion: Optional[String] = zio.aws.core.internal
      .optionalFromNullable(impl.osVersion())
      .map(value => value: String)
  }
  def wrap(
      impl: software.amazon.awssdk.services.ssmsap.model.AssociatedHost
  ): zio.aws.ssmsap.model.AssociatedHost.ReadOnly = new Wrapper(impl)
}
