package zio.aws.ssmsap.model
import zio.ZIO
import zio.aws.core.{AwsError, BuilderHelper}
import zio.prelude.data.Optional
import scala.jdk.CollectionConverters._
final case class Host(
    hostName: Optional[String] = Optional.Absent,
    hostRole: Optional[zio.aws.ssmsap.model.HostRole] = Optional.Absent,
    hostIp: Optional[String] = Optional.Absent,
    instanceId: Optional[String] = Optional.Absent
) {
  def buildAwsValue(): software.amazon.awssdk.services.ssmsap.model.Host = {
    import Host.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.ssmsap.model.Host
      .builder()
      .optionallyWith(hostName.map(value => value: java.lang.String))(
        _.hostName
      )
      .optionallyWith(hostRole.map(value => value.unwrap))(_.hostRole)
      .optionallyWith(hostIp.map(value => value: java.lang.String))(_.hostIp)
      .optionallyWith(instanceId.map(value => value: java.lang.String))(
        _.instanceId
      )
      .build()
  }
  def asReadOnly: zio.aws.ssmsap.model.Host.ReadOnly =
    zio.aws.ssmsap.model.Host.wrap(buildAwsValue())
}
object Host {
  private lazy val zioAwsBuilderHelper
      : BuilderHelper[software.amazon.awssdk.services.ssmsap.model.Host] =
    BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.ssmsap.model.Host = zio.aws.ssmsap.model.Host(
      hostName.map(value => value),
      hostRole.map(value => value),
      hostIp.map(value => value),
      instanceId.map(value => value)
    )
    def hostName: Optional[String]
    def hostRole: Optional[zio.aws.ssmsap.model.HostRole]
    def hostIp: Optional[String]
    def instanceId: Optional[String]
    def getHostName: ZIO[Any, AwsError, String] =
      AwsError.unwrapOptionField("hostName", hostName)
    def getHostRole: ZIO[Any, AwsError, zio.aws.ssmsap.model.HostRole] =
      AwsError.unwrapOptionField("hostRole", hostRole)
    def getHostIp: ZIO[Any, AwsError, String] =
      AwsError.unwrapOptionField("hostIp", hostIp)
    def getInstanceId: ZIO[Any, AwsError, String] =
      AwsError.unwrapOptionField("instanceId", instanceId)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.ssmsap.model.Host
  ) extends zio.aws.ssmsap.model.Host.ReadOnly {
    override val hostName: Optional[String] = zio.aws.core.internal
      .optionalFromNullable(impl.hostName())
      .map(value => value: String)
    override val hostRole: Optional[zio.aws.ssmsap.model.HostRole] =
      zio.aws.core.internal
        .optionalFromNullable(impl.hostRole())
        .map(value => zio.aws.ssmsap.model.HostRole.wrap(value))
    override val hostIp: Optional[String] = zio.aws.core.internal
      .optionalFromNullable(impl.hostIp())
      .map(value => value: String)
    override val instanceId: Optional[String] = zio.aws.core.internal
      .optionalFromNullable(impl.instanceId())
      .map(value => value: String)
  }
  def wrap(
      impl: software.amazon.awssdk.services.ssmsap.model.Host
  ): zio.aws.ssmsap.model.Host.ReadOnly = new Wrapper(impl)
}
